/*
 *        Name: GOPCLIBL EXEC
 *              CMS Gopher Client BookList, bookmark list browser
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1993-May-19
 */
 
/*
 *      Copyright 1993 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
/*  extract personal name from NAMES file  */
Parse Value Diag(08,'QUERY USERID') With user . host . '15'x .
'CALLPIPE COMMAND NAMEFIND :USERID' user ':NODE' host ,
        ':NAME | VAR PERSONAL'
If rc = 0 & personal ^= "" Then  /*  make a title line  */  ,
    'CALLPIPE COMMAND XMITMSG 40 PERSONAL' ,
        '(APPLID GOP CALLER CLI NOHEADER | VAR NAME'
Else  /*  use userid for in absence of personal name  */  ,
    'CALLPIPE COMMAND XMITMSG 44 USER' ,
        '(APPLID GOP CALLER CLI NOHEADER | VAR NAME'
name = Translate(name,' ','|')
 
Do Forever
 
    /*  extract bookmarks from GlobalVs  */
    'CALLPIPE COMMAND GLOBALV SELECT GOPHER LIST' ,
         '| LOCATE 1-10 / BOOKMARK./ | SPEC /=/ 1 2-* NEXT | VARLOAD'
    If ^Datatype(bookmark.0,'N') Then bookmark.0 = 0
                                 Else bookmark.0 = Trunc(bookmark.0)
 
    /*  note in environment that this is a BookList call  */
    Address "COMMAND" 'GLOBALV SELECT GOPHER SET ITEM'
 
    /*  feed bookmarks to menu browser  */
    'CALLPIPE STEM BOOKMARK. | GOPCLIMB' name '| *:'
    If rc ^= 0 Then Leave
 
    /*  how did we leave?  was it a "refresh"?  */
    Address "COMMAND" 'GLOBALV SELECT GOPHER GET COMMAND'
    Parse Upper Var command cmdverb .
    If ^Abbrev("REFRESH",cmdverb,1) Then Leave
 
    End  /*  Do  Forever  */
 
Exit
 
