/*
 *        Name: GOPCLIFV REXX
 *              VM TCP/IP Network GOPHER Client file viewer
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1992-Dec-23
 *
 *       Input: a plain-text file to view
 *      Output: zero or more information or error messages
 */
 
/*
 *      Copyright 1992 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
Trace "OFF"
 
Parse Arg args '(' . ')' .
 
/*  verify availability of input  */
'PEEKTO'
If rc ^= 0 & rc ^= 12 Then Exit rc
If rc = 12 Then Do  /*  Warning: file is empty  */
    'CALLPIPE COMMAND XMITMSG 559 (ERRMSG | *:'
    Exit
    End  /*  If  ..  Do  */
 
Address "COMMAND" 'GLOBALV SELECT GOPHER GET' ,
        'GOPHER PROGID VIEWER ITEM'
quit = 0
 
Parse Var item name '05'x path '05'x host '05'x port '05'x xtra
Parse Var name 1 . 2 name       /*  discard type indicator byte  */
Parse Var path 1 . 2 path       /*  discard type indicarot byte  */
If name = "" Then name = args
 
/*  fetch fs. stem variable from GlobalVs  */
'CALLPIPE COMMAND GLOBALV SELECT GOPHER LIST | DROP' ,
        '| LOCATE 1-4 / FS./ | SPEC /=/ 1 2-* NEXT | VARLOAD'
If rc ^= 0 Then Address "COMMAND" 'EXEC GOPCLINI'
If ^Datatype(fs.tube,'X') Then fs.tube = ""
 
message.0 = 0
command = ""
 
Select  /*  viewer  */
    When viewer = ""         Then Call BUILT_IN
    When viewer = "XEDIT"    Then Call XEDIT
    When viewer = "BROWSE"   Then Call BROWSE
    Otherwise                     Call ANYOTHER
    /*
        handle disk-full conditions!
     */
    End  /*  Select  viewer  */
vrc = rc
 
'CALLPIPE STEM MESSAGE. | *:'
 
Address "COMMAND" 'GLOBALV SELECT GOPHER PUT COMMAND'
 
Exit vrc
 
 
/* ============================================================ BUILT_IN
 */
BUILT_IN:
 
/*  read the file from the preceding stage  */
'CALLPIPE *: | UNTAB -8 | XLATE OUTPUT | XLATE *-* 00-3F 40 FF 40' ,
    '| STRIP TRAILING | PAD 1 | DEBLOCK FIXED' fs.scrcols '| STEM FILE.'
 
/*  display the file and process user's response  */
row = 3;        col = 0
ki = file.0;    kl = fs.scrrows - 5;    ko = 1
needle = ""     /*  may be re-used within this context  */
 
'CALLPIPE COMMAND XMITMSG 614 (APPLID GOP' ,
        'NOCOMP NOHEADER | STEM HELP.'
 
'CALLPIPE COMMAND XMITMSG 5 (APPLID GOP NOHEADER | VAR MORE'
 
Do Forever
 
    /*  write the program title line  */
    wscreen = sba(0,-1) || field("BLUE","PROT") || sba(0,0) || progid ,
                        || sba(0,fs.scrcols-Length(host)-1) || host
 
    /*  no SBA for status because it follows host immediately  */
    If message.0 < 1 Then Do
    wscreen = wscreen   || field("PROT") || Left(ko || '/' || ki, 11)
    If ko + kl <= ki Then
    wscreen = wscreen   || field("WHITE","HIGH","PROT") || more
        End  /*  If  ..  Do  */
 
    /*  don't write status or name if they'll be overlaid  */
    If message.0 < 2 Then
    wscreen = wscreen   || sba(2,(fs.scrcols-Length(name))/2) ,
                        || field("WHITE","PROT") || name
 
    /*  write as many message lines as needed  */
    If message.0 > 0 Then Do i = 1 to Min(message.0,kl+2)
        wscreen = wscreen || sba(i,-1) ,
            || field("RED","HIGH","PROT") || message.i
        End  /*  If  ..  Do  For  */
 
    i = Max(1,message.0-1); j = ko
    wscreen = wscreen || sba(i+2,-1) || field("GREEN","PROT")
    Do While i <= kl & j <= ki
        wscreen = wscreen || Left(file.j,fs.scrcols)
        i = i + 1;  j = j + 1
        End
 
    message.0 = 0
 
    /*  write those PFkey settings  */
    wscreen = wscreen   || sba(fs.scrrows-2,-1) ,
                        || field("BLUE","PROT") || help.1 ,
                        || sba(fs.scrrows-1,-1) ,
                        || field("BLUE","PROT") || help.2
 
    rscreen = write_read(wscreen || sba(row,col) || '13'x)
    Parse Var rscreen 1 aid 2 offset . '11'x rscreen
    offset = fix(offset)
    row = offset % fs.scrcols; col = offset // fs.scrcols
 
    /*  keep the  row/col  values within bounds  */
    row = 3     /* just reset it */
    col = 0     /* just reset it */
 
    Select /* aid */
        When  aid = '7D'x   /* enter */ Then nop
        When  aid = 'F2'x   /*  PF2  */ | ,
              aid = 'C2'x   /*  PF14 */ Then Do
            command = "NEXT"
            Leave
            End  /*  When  ..  Do  */
        When  aid = 'F3'x   /*  PF3  */ | ,
              aid = 'C3'x   /*  PF15 */ Then Leave
        When  aid = 'F4'x   /*  PF4  */ | ,
              aid = 'C4'x   /*  PF16 */ Then Call PRINT
        When  aid = 'F5'x   /*  PF5  */ | ,
              aid = 'C5'x   /*  PF17 */ Then Call SAVE
        When  aid = 'F6'x   /*  PF6  */ | ,
              aid = 'C6'x   /*  PF18 */ Then Call FIND
        When  aid = 'F7'x   /*  PF7  */ | ,
              aid = 'C7'x   /*  PF19 */ Then ko = Max(ko-kl+1,1)
        When  aid = 'F8'x   /*  PF8  */ | ,
              aid = 'C8'x   /*  PF20 */ Then ko = Min(ko+kl-1,ki)
        When  aid = 'F9'x   /*  PF9  */ | ,
              aid = 'C9'x   /*  PF21 */ Then  Call  MARK
        When  aid = '7A'x   /*  PF10 */ | ,
              aid = '4A'x   /*  PF22 */ Then  Call  BOOKLIST
        When  aid = '7B'x   /*  PF11 */ | ,
              aid = '4B'x   /*  PF23 */ Then Call SUBXEDIT
        When  aid = '6D'x   /* clear */ | ,
              aid = '6E'x   /*  PA2  */ Then Do
            row = 3; col = 0; ko = 1
            End  /*  When ..  Do  */
        When  aid = '7C'x   /*  PF12 */ | ,
              aid = '4C'x   /*  PF24 */ | ,
              aid = 'F0'x   /* sysrq */ | ,
              aid = '6C'x   /*  PA1  */ Then Do
            command = "QUIT"
            Leave
            End  /*  When  ..  Do  */
        When  aid = 'F1'x   /*  PF1  */ | ,
              aid = 'C1'x   /*  PF13 */ Then  Call  HELP
        When  aid = '00'x               Then Do
            /*  I/O error on screen  */
            'CALLPIPE COMMAND XMITMSG 925 (APPLID GOP' ,
                    'CALLER FVW ERRMSG | STEM MESSAGE. APPEND'
            Leave
            End  /*  When  ..  Do  */
        Otherwise  Do   /*  Undefined PFkey/PAkey  */
            'CALLPIPE COMMAND XMITMSG 657 "' || c2x(aid) || '"' ,
                '(APPLID GOP CALLER FVW ERRMSG | STEM MESSAGE. APPEND'
            End  /*  Otherwise  Do  */
        End  /*  Select  aid  */
 
    End  /*  Do  Forever  */
 
Return
 
 
 
/* =============================================================== XEDIT
 *  Take the "file" from the input stream and pass it to CMS XEDIT.
 */
XEDIT:
 
If fs.tube ^= "" Then Do
    /*  "Can't run XEDIT on this terminal."  */
    'CALLPIPE COMMAND XMITMSG 512 "XEDIT"' ,
            '(APPLID GOP CALLER FVW ERRMSG | STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
/*  stash this in a temporary file  */
'CALLPIPE *: | > VMGOPHER DOCUMENT A3'
 
/*  what's the real name of the file?  */
Parse Value gopclifi(path) With fn ft .
Push "COMMAND SET FNAME" fn
Push "COMMAND SET FTYPE" ft
Push "COMMAND SET FMODE A1"
 
/*  now invoke XEDIT  */
'CALLPIPE COMMAND STATE GOPXEDPR XEDIT *'
If rc = 0 Then Address "COMMAND" ,
                'XEDIT VMGOPHER DOCUMENT A (PROFILE GOPXEDPR'
          Else Do
               Push "COMMAND SET SYNONYM ITEMINFO 4 GOPXEDII"
               Address "COMMAND"  'XEDIT VMGOPHER DOCUMENT A'
          End
 
Return
 
 
 
/* ============================================================== BROWSE
 *  Take the "file" from the input stream and pass it to CMS BROWSE.
 */
BROWSE:
 
If fs.tube ^= "" Then Do
    /*  "Can't run BROWSE on this terminal."  */
    'CALLPIPE COMMAND XMITMSG 512 "BROWSE"' ,
            '(APPLID GOP CALLER FVW ERRMSG | STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
Parse Value gopclifi(path) With fn ft .
filespec = fn ft 'A'
 
'CALLPIPE CMS STATE' filespec '| STEM MESSAGE.'
If  rc ^= 0 & rc ^= 28 & rc ^= 20  Then Return
If  rc = 0 | rc = 20  Then Do
    fn = "VMGOPHER"
    ft = "DOCUMENT"
    End  /*  If  ..  Do  */
message.0 = 0
 
/*  stash this in a temporary file  */
'CALLPIPE *: | >' fn ft 'A3'
 
/* stash this in a temporary file and invoke BROWSE */
Address "COMMAND" 'BROWSE' filespec
 
Return
 
 
 
/* ============================================================ ANYOTHER
 *  View the file with some unknown text editor or file browser.
 */
ANYOTHER:
 
If fs.tube ^= "" Then Do
    /*  "Can't run" viewer "on this terminal."  */
    'CALLPIPE COMMAND XMITMSG 512 VIEWER' ,
            '(APPLID GOP CALLER FVW ERRMSG | STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
Parse Value gopclifi(path) With fn ft .
filespec = fn ft 'A'
 
'CALLPIPE CMS STATE' filespec '| STEM MESSAGE.'
If  rc ^= 0 & rc ^= 28 & rc ^= 20  Then Return
If  rc = 0 | rc = 20  Then Do
    fn = "VMGOPHER"
    ft = "DOCUMENT"
    End  /*  If  ..  Do  */
message.0 = 0
 
/*  stash this in a temporary file  */
'CALLPIPE *: | >' fn ft 'A3'
 
/* stash this in a temporary file and invoke the viewer  */
'CALLPIPE CMS' viewer filespec '| CONSOLE'
 
Return
 
 
 
/* ---------------------------------------------------------------- HELP
 * Invoke CMS HELP passing any supplied argument (context sensitive).
 */
HELP:     Procedure Expose fs. message.
 
If fs.tube ^= "" Then
    'CALLPIPE COMMAND HELP GOPHER VIEWER (ALL' ,
        '| GOPCLIFV VIEWER HELP' ,
            '| STEM MESSAGE. APPEND'
 
Else Do
    'CALLPIPE COMMAND HELP GOPHER VIEWER'
    Address "COMMAND" 'VMFCLEAR'
    End  /*  Else  Do  */
 
Return
 
 
 
/* ------------------------------------------------------------ SUBXEDIT
 *  Take the file in storage and pass it to CMS XEDIT.
 */
SUBXEDIT:
 
If fs.tube ^= "" Then Do
    /*  "Can't run XEDIT on this terminal."  */
    'CALLPIPE COMMAND XMITMSG 512 "XEDIT"' ,
            '(APPLID GOP CALLER FVW ERRMSG | STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
/*  stash this in a temporary file  */
'CALLPIPE STEM FILE. | > VMGOPHER DOCUMENT A3'
 
/*  what's the real name of the file?  */
Parse Value gopclifi(path) With fn ft .
Push "COMMAND SET FNAME" fn
Push "COMMAND SET FTYPE" ft
Push "COMMAND SET FMODE A1"
 
/*  now invoke XEDIT  */
'CALLPIPE COMMAND STATE GOPXEDPR XEDIT *'
If rc = 0 Then Address "COMMAND" ,
                'XEDIT VMGOPHER DOCUMENT A (PROFILE GOPXEDPR'
          Else Do
               Push "COMMAND SET SYNONYM ITEMINFO 4 GOPXEDII"
               Address "COMMAND"  'XEDIT VMGOPHER DOCUMENT A'
          End
 
Return
 
 
 
/* --------------------------------------------------------------- PRINT
 *  Take the current "file" in context and send it to the user's
 *  virtual printer.  Printer may be SPOOLed CONTinuous.
 */
PRINT:
 
If fs.tube ^= "" Then Do
    /*  "Can't PRINT from this terminal."  */
    'CALLPIPE COMMAND XMITMSG 507 (APPLID GOP CALLER FVW ERRMSG' ,
            '| STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
'CALLPIPE STEM FILE. | PRINT (TITLE' name '| STEM MESSAGE. APPEND'
 
Return
 
 
 
/* ---------------------------------------------------------------- SAVE
 * Save the current file being viewed to the user's A disk.
 */
SAVE:
 
If fs.tube ^= "" Then Do
    Call MESSAGE "Can't SAVE files via this terminal."
    Return
    End /* If .. Do */
 
Parse Value gopclifi(path) With fn ft .
filespec = fn ft 'A'
 
'CALLPIPE CMS STATE' filespec '| STEM MESSAGE.'
If rc = 0 Then Do
    'CALLPIPE COMMAND XMITMSG 24 FILESPEC' ,
        '| SPLIT AT /;/ | TAKE | STEM MESSAGE.'
    Return
    End  /*  If  ..  Do  */
If rc ^= 28 Then Return
message.0 = 0
 
'CALLPIPE STEM FILE. | >' filespec
If rc = 0 Then Do
    /*  Creating new file:  */
    'CALLPIPE COMMAND XMITMSG 571 | STEM MESSAGE. APPEND'
    message.1 = message.1 filespec
/*  Call message "Created" filespec "from" path  */
    End  /*  If  ..  Do  */
 
Return
 
 
 
/* ---------------------------------------------------------------- FIND
 *  Find a particular string within the file being viewed.
 */
FIND:
 
'CALLPIPE COMMAND XMITMSG 602 "' || needle || '" (APPLID GOP' ,
        'CALLER FVW NOHEADER | GOPCLIUI | VAR NEEDLE'
needle = Translate(Strip(needle))
If needle = "" Then Return
 
Do i = ko + 1 to ki
    If Index(Translate(file.i),needle) > 0 Then Do
        ko = i
        Return
        End  /*  If  ..  Do  */
    End  /*  Do  For  */
 
/*  'CALLPIPE COMMAND XMITMSG 546 (ERRMSG'  CALLER DMS is OK  */
/*  "Target not found"  */
'CALLPIPE COMMAND XMITMSG 546 (APPLID GOP CALLER FVW ERRMSG' ,
        '| STEM MESSAGE. APPEND'
 
Return
 
 
 
 
/* ---------------------------------------------------------------- MARK
 *  Save a book mark referencing this file.
 */
MARK:
 
If fs.tube ^= "" Then Do
    /*  "Can't set bookmarks from this screen."  */
    'CALLPIPE COMMAND XMITMSG 43 (APPLID GOP CALLER FVW ERRMSG' ,
            '| STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
Address "COMMAND" 'GLOBALV SELECT GOPHER GET BOOKMARK.0'
If ^Datatype(bookmark.0,'N') Then bookmark.0 = 0
i = bookmark.0 + 1
bookmark.i = item
Address "COMMAND" 'GLOBALV SELECT GOPHER PUTP BOOKMARK.' || i
bookmark.0 = i
Address "COMMAND" 'GLOBALV SELECT GOPHER PUTP BOOKMARK.0'
 
If rc = 0 Then 'CALLPIPE COMMAND XMITMSG 41 I' ,
    '(APPLID GOP CALLER FVW ERRMSG | STEM MESSAGE. APPEND'
    /*  "Bookmark" i "saved."  */
          Else 'CALLPIPE COMMAND XMITMSG 514 RC "GLOBALV"' ,
        '(APPLID GOP CALLER FVW ERRMSG | STEM MESSAGE. APPEND'
 
Return
 
 
 
/* ------------------------------------------------------------ BOOKLIST
 *  Call GOPCLIBL (booklist) to show the list of bookmarks.
 *  (GOPCLIBL then feeds GOPCLIMB, the menu browser)
 */
BOOKLIST:
 
'CALLPIPE GOPCLIBL | STEM MESSAGE. APPEND'
 
Return
 
 
 
/* ----------------------------------------------------------------- FIX
 * Takes an inbound 3270 DS screen address (two bytes)
 * and returns the equivalent byte offset in decimal.
 */
FIX:
Parse Arg o,.
Parse Var o 1 o1 2 o2 3 .
o1 = c2d(o1)
o2 = c2d(o2)
If o1 < 64 Then Return o1 * 256 + o2
           Else Return (o1 // 64) * 64 + (o2 // 64)
 
 
 
/* ---------------------------------------------------------- WRITE_READ
 * Display what we have, then wait for user input and return it.
 */
WRITE_READ: Procedure Expose fs.
Parse Arg ws,wcc,wrt,.
If wcc = "" Then wcc = 'C3'x
/*  If wrt = "" Then wrt = 'C0'x  */
If wrt = "" Then wrt = fs.write
ws = wrt || wcc || ws
'CALLPIPE VAR WS | FULLSCR' fs.tube 'PATH' gopher 'NOCLOSE | VAR RS'
If rc ^= 0 Then rs = '000000'x
Return rs
 
 
 
/* ----------------------------------------------------------------- SBA
 * (a better SBA function extracted from PIPEDEMO; thanks, Chuck!)
 * Construct Set Buffer Address order from row and column.
 */
 
SBA:      Procedure Expose fs.
 
arg row , col, .
row = Trunc(row)
col = Trunc(col)
 
/*-----------------------------------------------------------------*/
/* Calculate binary address.                                       */
/*-----------------------------------------------------------------*/
 
offset = row * fs.scrcols + col
Do While offset < 0; offset = offset + fs.scrrows * fs.scrcols; End
 
if fs.14bit then return '11'x || d2c(offset,2)
 
/*-----------------------------------------------------------------*/
/* Convert to six-bit format. (xxxx111111111111 -> 0011111100111111*/
/*-----------------------------------------------------------------*/
 
'CALLPIPE var offset'               ,   /* Start with char number.    */
    '| spec 1-* d2c 1.2 right'      ,   /* Convert to binary.         */
    '| spec 1-* c2b 1'              ,   /* Convert to bit string.     */
    '| spec /00/ 1  5.6  3'         ,   /* Place first six bits.      */
           '/00/ 9 11.6 11'         ,   /* Place second six bits.     */
    '| spec 1-* b2c 1'              ,   /* Convert back to binary.    */
    '| xlate *-* 00-3F 40-7F'       ,   /* Translate to coded         */
                '01-09 C1-C9'       ,   /*   buffer address.          */
                '11-19 D1-D9'       ,   /*                            */
                '22-29 E2-E9'       ,   /*                            */
                '30-39 F0-F9'       ,   /*                            */
    '| spec x11 1 1.2 2'            ,   /* Prefix with SBA order.     */
    '| var offset'                      /* Put back in variable.      */
 
Return offset
 
 
 
/* --------------------------------------------------------------- FIELD
 * Generate the 3270 DS sequence for extended field attributes
 * (if available).
 */
FIELD:    Procedure Expose fs.
a = '00'x
b = '00'x
c = 'F1'x
i = 1
Do While Arg(i) ^= ""
    Select  /*  at  */
        When Abbrev("PROTECTED",Arg(i),2)   Then a = bitor(a,'20'x)
        When Abbrev("SKIP",Arg(i),1)        Then a = bitor(a,'10'x)
        When Abbrev("NODISPLAY",Arg(i),1)   Then a = bitor(a,'0C'x)
        When Abbrev("HIGH",Arg(i),1)        Then a = bitor(a,'08'x)
        When Abbrev("BLINK",Arg(i),3)       Then b = bitor(b,'01'x)
        When Abbrev("REVERSE",Arg(i),3)     Then b = bitor(b,'02'x)
        When Abbrev("UNDERLINE",Arg(i),1)   Then b = bitor(b,'04'x)
        When Abbrev("BLUE",Arg(i),3)        Then c = 'F1'x
        When Abbrev("RED",Arg(i),3)         Then c = 'F2'x
        When Abbrev("PINK",Arg(i),1)        Then c = 'F3'x
        When Abbrev("GREEN",Arg(i),1)       Then c = 'F4'x
        When Abbrev("TURQUOISE",Arg(i),1)   Then c = 'F5'x
        When Abbrev("YELLOW",Arg(i),1)      Then c = 'F6'x
        When Abbrev("WHITE",Arg(i),1)       Then c = 'F7'x
        Otherwise nop
        End  /*  Select  at  */
    i = i + 1
    End  /*  Do  While  */
 
If  ^fs.color   | ,
    ^fs.exthi   Then    Return '1D'x || bitor(a,'40'x)
                Else    Return '2902'x || ,
                               'C0'x   || bitor(a,'40'x) || ,
                               '42'x   || bitor(c,'40'x)
 
