/*
 *        Name: GOPCLIGV REXX
 *              VM TCP/IP Network GOPHER Client graphics viewer
 *              This file is part of CMS Gopher and not part of VMGIF.
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1992-Dec-23
 *
 *        Note: the first record must be at least long enough
 *              to identify the graphics format (magic number)
 */
 
/*
 *      Copyright 1992 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
/*  Trace "OFF"  */
 
'PEEKTO RECORD'
Select
    When Left(record,5) = '4749463837'x Then Signal GIF
    Otherwise 'OUTPUT' "unknown graphics format"
    End  /*  Select  */
 
Exit rc * (rc ^= 12)
 
 
 
/* ------------------------------------------------------------------ */
GIF:
 
/*  verify that we have the VMGIF disk accessed  */
'CALLPIPE CMS STATE VMGIF MODULE * | *:'
If rc ^= 0 Then Exit rc
 
/*  try to stash the input stream in a temp file  */
'CALLPIPE *: | > TEMP#GIF GIF A3'
If rc ^= 0 Then Do
    grc = rc
    'CALLPIPE COMMAND ERASE TEMP#GIF GIF A'
    Exit grc
    End  /*  If  ..  Do  */
 
/*  ensure that the right libraries are GLOBALed  */
/*  (I loathe doing this)  */
'CALLPIPE COMMAND QUERY TXTLIB' ,
    '| STRIP LEADING STRING /TXTLIB   = / | JOIN * | VAR TXTLIB'
Upper txtlib;   If Strip(txtlib) = "NONE" Then txtlib = ""
'CALLPIPE COMMAND GLOBAL TXTLIB ADMPLIB ADMGLIB' txtlib
 
/*  now run VMGIF  */
'CALLPIPE CMS VMGIF -em5 TEMP#GIF | *:'; grc = rc
 
/*  restore GLOBALed libraries  */
'CALLPIPE COMMAND GLOBAL TXTLIB' txtlib
 
Exit grc
 
