/*
 *        Name: GOPCLIMB REXX
 *              VM TCP/IP Network GOPHER Client menu browser
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1992-Dec-23
 *
 *       Input: one or more gopher menu lines
 *      Output: zero or more information or error messages
 */
 
/*
 *      Copyright 1992 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
Trace "OFF"
 
Parse Arg args '(' . ')' .
 
/*  verify availability of input  */
'PEEKTO'
If rc ^= 0 & rc ^= 12 Then Exit rc
If rc = 12 Then Do  /*  empty menu  */
    'CALLPIPE COMMAND XMITMSG 60 (APPLID GOP CALLER CLI ERRMSG | *:'
    Exit
    End  /*  If  ..  Do  */
 
Address "COMMAND" 'GLOBALV SELECT GOPHER GET' ,
        'GOPHER PROGID VIEWER ITEM'
 
Parse Var item name '05'x path '05'x host '05'x port '05'x xtra
Parse Var name 1 . 2 name       /*  discard type indicator byte  */
Parse Var path 1 . 2 path       /*  discard type indicator byte  */
If name = "" Then name = args
booklist = (item = "")
 
/*  fetch fs. stem variable from GlobalVs  */
'CALLPIPE COMMAND GLOBALV SELECT GOPHER LIST | DROP' ,
        '| LOCATE 1-4 / FS./ | SPEC /=/ 1 2-* NEXT | VARLOAD'
If ^Datatype(fs.tube,'X') Then fs.tube = ""
 
'CALLPIPE *: | STEM MENU.'
 
/* is it a server error? */
If menu.0 = 1 & Left(menu.1,1) = '-' Then Do
    Parse Var menu.1 . '-' errmsg '05'x .
    'OUTPUT' errmsg
    Exit
    End  /*  If  ..  Do  */
 
/*  display the menu and process user's response  */
row = 0;        col = 0         /*  reset later  */
ki = menu.0;    kl = fs.scrrows - 5;    ko = 1
needle = ""     /*  may be re-used within this context  */
message.0 = 0
 
If booklist Then 'CALLPIPE COMMAND XMITMSG 615' ,
        '(APPLID GOP CALLER CLI NOCOMP | SPEC WORD 2-* 1 | STEM HELP.'
            Else 'CALLPIPE COMMAND XMITMSG 613' ,
        '(APPLID GOP CALLER CLI NOCOMP | SPEC WORD 2-* 1 | STEM HELP.'
 
'CALLPIPE COMMAND XMITMSG 5 (APPLID GOP NOHEADER | VAR MORE'
 
Do Forever
 
    /*  write the program title line  */
    wscreen = sba(0,-1) || field("BLUE","PROT") || sba(0,0) || progid ,
                        || sba(0,fs.scrcols-Length(host)-1) || host
 
    /*  no SBA for status because it follows host immediately  */
    If message.0 < 1 Then Do
    wscreen = wscreen   || field("PROT") || Left(ko || '/' || ki, 11)
    If ko + kl <= ki Then
    wscreen = wscreen   || field("WHITE","HIGH","PROT") || more
        End  /*  If  ..  Do  */
 
    /*  don't write status or name if they'll be overlaid  */
    If message.0 < 2 Then
    wscreen = wscreen   || sba(2,(fs.scrcols-Length(name))/2) ,
                        || field("WHITE","PROT") || name
 
    /*  write as many message lines as needed  */
    If message.0 > 0 Then Do
        Do i = 1 to message.0
            wscreen = wscreen || sba(i,-1) ,
                || field("RED","HIGH","PROT") || message.i
            End  /*  Do  For  */
        message.0 = 0
        End  /*  If  ..  Do  */
    /*  we should probably limit that count  */
 
    /*  write those PFkey settings  */
    wscreen = wscreen   || sba(fs.scrrows-2,-1) ,
                        || field("BLUE","PROT") ,
                        || help.1 ,
                        || sba(fs.scrrows-1,-1) ,
                        || field("BLUE","PROT") ,
                        || help.2
 
    i = 1; j = ko
    Do While i <= kl & j <= ki
 
        Parse Var menu.j _name '05'x .
        Parse Var _name 1 _type 2 _name
        'CALLPIPE VAR _NAME | XLATE OUTPUT' ,
            '| XLATE *-* 00-3F 40 FF 40 | VAR _NAME'
 
        wscreen = wscreen || sba(i+2,-1) ,
                          || field("BLUE","PROT","HIGH")
        If _type = 'i' Then
        wscreen = wscreen || Left(_name,fs.scrcols-1)
                      Else Do
        wscreen = wscreen || Left(gtag(_type),11) ,
                          || field("GREEN") ,
                          || Left(_name,fs.scrcols-13)
            If row = 0 Then Do
                row = i + 2;    col = 12
                End  /*  If  ..  Do  */
            End  /*  Else  Do  */
 
        i = i + 1;  j = j + 1
 
        End  /*  Do  While  */
 
    rscreen = write_read(wscreen || sba(row,col) || '13'x)
    Parse Var rscreen 1 aid 2 offset . '11'x rscreen
    offset = fix(offset)
    row = offset % fs.scrcols; col = offset // fs.scrcols
 
    /*  keep the row/col values within bounds  */
    If  row      <   3       Then row = 3
    If  row      >   kl + 3  Then row = kl + 3
    If  row + ko >   ki + 3  Then row = ki + 3 - ko
    col = 12    /*  just reset it  */
 
    i = row + ko - 3
 
    command = ""    /*  reset the command string on each iteration  */
 
    Select /* aid */
        When  aid = '7D'x   /* enter */ | ,
              aid = 'F2'x   /*  PF2  */ | ,
              aid = 'C2'x   /*  PF14 */ | ,
              aid = '7B'x   /*  PF11 */ | ,
              aid = '4B'x   /*  PF23 */ Then  Call  OPEN
        When  aid = 'F3'x   /*  PF3  */ | ,
              aid = 'C3'x   /*  PF15 */ Then  Leave
        When  aid = 'F4'x   /*  PF4  */ | ,
              aid = 'C4'x   /*  PF16 */ Then  Call  PRINT
        When  aid = 'F5'x   /*  PF5  */ | ,
              aid = 'C5'x   /*  PF17 */ Then  Call  KEEP
        When  aid = 'F6'x   /*  PF6  */ | ,
              aid = 'C6'x   /*  PF18 */ Then  Call  FIND
        When  aid = 'F7'x   /*  PF7  */ | ,
              aid = 'C7'x   /*  PF19 */ Then Do
            ko = Max(ko-kl+1,1)
            row = 3
            End  /*  When  ..  Do  */
        When  aid = 'F8'x   /*  PF8  */ | ,
              aid = 'C8'x   /*  PF20 */ Then Do
            ko = Min(ko+kl-1,ki)
            row = 3
            End  /*  When  ..  Do  */
        When  aid = 'F9'x   /*  PF9  */ | ,
              aid = 'C9'x   /*  PF21 */ Then  Call  MARK
        When  aid = '7A'x   /*  PF10 */ | ,
              aid = '4A'x   /*  PF22 */ Then  Call  BOOKLIST
        When  aid = '6D'x   /* clear */ | ,
              aid = '6E'x   /*  PA2  */ Then Do
            row = 3;    col = 12;   ko = 1
            End  /*  When ..  Do  */
        When  aid = '7C'x   /*  PF12 */ | ,
              aid = '4C'x   /*  PF24 */ | ,
              aid = 'F0'x   /* sysrq */ | ,
              aid = '6C'x   /*  PA1  */ Then  command = "QUIT"
        When  aid = 'F1'x   /*  PF1  */ | ,
              aid = 'C1'x   /*  PF13 */ Then  Call  HELP
        When  aid = '00'x               Then Do
            /*  I/O error on screen  */
            'CALLPIPE COMMAND XMITMSG 925 (APPLID GOP' ,
                    'CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
            Leave
            End
        Otherwise  Do   /*  Undefined PFkey/PAkey  */
            'CALLPIPE COMMAND XMITMSG 657 "' || c2x(aid) || '"' ,
                '(APPLID GOP CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
            End  /*  Otherwise  Do  */
        End  /*  Select  aid  */
 
    Parse Upper Var command cmdverb .
    If Abbrev("QUIT",cmdverb,1)     Then Leave
    If Abbrev("REFRESH",cmdverb,1)  Then Leave
 
    End  /*  Do  Forever  */
 
'CALLPIPE STEM MESSAGE. | *:'
 
Address "COMMAND" 'GLOBALV SELECT GOPHER PUT COMMAND'
 
Exit
 
 
 
/* ---------------------------------------------------------------- OPEN
 */
OPEN:
 
Do Forever
    Address "COMMAND" 'GLOBALV SELECT GOPHER SET COMMAND OPEN'
    'CALLPIPE VAR MENU.' || i '| GOPCLITM OPEN | STEM MESSAGE. APPEND'
    If rc ^= 0 Then Leave
    Address "COMMAND" 'GLOBALV SELECT GOPHER GET COMMAND'
    Parse Upper Var command next .
    If next ^= "NEXT" Then Leave
    If i >= ki Then Leave
    i = i + 1
    End  /*  Do  Forever  */
 
If i > ko + kl Then ko = Min(i,ki)
row = i - ko + 3
 
If next = "NEXT" Then command = ""
 
Return
 
 
 
/* --------------------------------------------------------------- PRINT
 * Print the current "menu" on the user's virtual printer.
 */
PRINT:
 
If fs.tube ^= "" Then Do
    /*  "Can't PRINT from this terminal."  */
    'CALLPIPE COMMAND XMITMSG 507 (APPLID GOP CALLER CLI ERRMSG' ,
            '| STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
'CALLPIPE STEM MENU. | XLATE *-* 05 7A' ,
        '| PRINT (TITLE' name '| STEM MESSAGE. APPEND'
 
Return
 
 
 
/* ---------------------------------------------------------------- KEEP
 */
KEEP:
 
'CALLPIPE VAR MENU.' || i '| GOPCLITM KEEP | STEM MESSAGE. APPEND'
 
Return
 
 
 
/* ---------------------------------------------------------------- FIND
 *  Find a particular string within the menu being viewed.
 *  Call GOPCLIUI for user input with prompt.
 */
FIND:
 
'CALLPIPE COMMAND XMITMSG 602 "' || needle || '" (APPLID GOP' ,
        'CALLER CLI NOHEADER | GOPCLIUI | VAR NEEDLE'
needle = Translate(Strip(needle))
If needle = "" Then Return
 
Do i = ko + 1 to ki
    If Index(Translate(menu.i),needle) > 0 Then Do
        ko = i
        Return
        End  /*  If  ..  Do  */
    End  /*  Do  For  */
 
/*  'CALLPIPE COMMAND XMITMSG 546 (ERRMSG'  CALLER DMS is OK  */
/*  "Target not found"  */
'CALLPIPE COMMAND XMITMSG 546 (APPLID GOP CALLER CLI ERRMSG' ,
        '| STEM MESSAGE. APPEND'
 
Return
 
 
 
/* ---------------------------------------------------------------- MARK
 *  Save a bookmark referencing this menu,
 *  or  (if in "booklist" mode)  delete the bookmark at the cursor.
 */
MARK:
 
If fs.tube ^= "" Then Do
    /*  "Can't set bookmarks from this screen."  */
    'CALLPIPE COMMAND XMITMSG 43 (APPLID GOP CALLER CLI ERRMSG' ,
            '| STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
If booklist Then Do
    'CALLPIPE COMMAND XMITMSG 42 I (APPLID GOP NOHEADER' ,
        '| SPEC /i            / 1 1-* NEXT | VAR BOOKMARK.' || i
    If rc = 0 Then
    Address "COMMAND" 'GLOBALV SELECT GOPHER PUTP BOOKMARK.' || i
    If rc = 0 Then 'CALLPIPE COMMAND XMITMSG 42 I' ,
        '(APPLID GOP CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
        /*  "Bookmark" i "deleted."  */
    Else 'CALLPIPE COMMAND XMITMSG 514 RC "GLOBALV"' ,
        '(APPLID GOP CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
Address "COMMAND" 'GLOBALV SELECT GOPHER GET BOOKMARK.0'
If ^Datatype(bookmark.0,'N') Then bookmark.0 = 0
i = bookmark.0 + 1
bookmark.i = item
Address "COMMAND" 'GLOBALV SELECT GOPHER PUTP BOOKMARK.' || i
bookmark.0 = i
Address "COMMAND" 'GLOBALV SELECT GOPHER PUTP BOOKMARK.0'
 
If rc = 0 Then 'CALLPIPE COMMAND XMITMSG 41 I' ,
    '(APPLID GOP CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
    /*  "Bookmark" i "saved."  */
          Else 'CALLPIPE COMMAND XMITMSG 514 RC "GLOBALV"' ,
        '(APPLID GOP CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
 
Return
 
 
 
/* ------------------------------------------------------------ BOOKLIST
 *  Call GOPCLIBL (booklist) to show the list of bookmarks.
 *  (GOPCLIBL then feeds another instance of this stage, GOPCLIMB)
 */
BOOKLIST:
 
If booklist Then command = "REFRESH"
            Else 'CALLPIPE GOPCLIBL | STEM MESSAGE. APPEND'
 
Return
 
 
 
/* ----------------------------------------------------------------- FIX
 * Takes an inbound 3270 DS screen address (two bytes)
 * and returns the equivalent byte offset in decimal.
 */
FIX:
Parse Arg o,.
Parse Var o 1 o1 2 o2 3 .
o1 = c2d(o1)
o2 = c2d(o2)
If o1 < 64 Then Return o1 * 256 + o2
           Else Return (o1 // 64) * 64 + (o2 // 64)
 
 
 
/* ---------------------------------------------------------- WRITE_READ
 * Display what we have, then wait for user input and return it.
 */
WRITE_READ: Procedure Expose fs.
Parse Arg ws,wcc,wrt,.
If wcc = "" Then wcc = 'C3'x
/*  If wrt = "" Then wrt = 'C0'x  */
If wrt = "" Then wrt = fs.write
ws = wrt || wcc || ws
'CALLPIPE VAR WS | FULLSCR' fs.tube 'PATH' gopher 'NOCLOSE | VAR RS'
If rc ^= 0 Then rs = '000000'x
Return rs
 
 
 
/* ----------------------------------------------------------------- SBA
 * (a better SBA function extracted from PIPEDEMO; thanks, Chuck!)
 * Construct Set Buffer Address order from row and column.
 */
 
SBA:      Procedure Expose fs.
 
arg row , col, .
row = Trunc(row)
col = Trunc(col)
 
/*-----------------------------------------------------------------*/
/* Calculate binary address.                                       */
/*-----------------------------------------------------------------*/
 
offset = row * fs.scrcols + col
Do While offset < 0; offset = offset + fs.scrrows * fs.scrcols; End
 
if fs.14bit then return '11'x || d2c(offset,2)
 
/*-----------------------------------------------------------------*/
/* Convert to six-bit format. (xxxx111111111111 -> 0011111100111111*/
/*-----------------------------------------------------------------*/
 
'CALLPIPE var offset'               ,   /* Start with char number.    */
    '| spec 1-* d2c 1.2 right'      ,   /* Convert to binary.         */
    '| spec 1-* c2b 1'              ,   /* Convert to bit string.     */
    '| spec /00/ 1  5.6  3'         ,   /* Place first six bits.      */
           '/00/ 9 11.6 11'         ,   /* Place second six bits.     */
    '| spec 1-* b2c 1'              ,   /* Convert back to binary.    */
    '| xlate *-* 00-3F 40-7F'       ,   /* Translate to coded         */
                '01-09 C1-C9'       ,   /*   buffer address.          */
                '11-19 D1-D9'       ,   /*                            */
                '22-29 E2-E9'       ,   /*                            */
                '30-39 F0-F9'       ,   /*                            */
    '| spec x11 1 1.2 2'            ,   /* Prefix with SBA order.     */
    '| var offset'                      /* Put back in variable.      */
 
Return offset
 
 
 
/* --------------------------------------------------------------- FIELD
 * Generate the 3270 DS sequence for extended field attributes
 * (if available).
 */
FIELD:    Procedure Expose fs.
a = '00'x
b = '00'x
c = 'F1'x
i = 1
Do While Arg(i) ^= ""
    Select  /*  at  */
        When Abbrev("PROTECTED",Arg(i),2)   Then a = bitor(a,'20'x)
        When Abbrev("SKIP",Arg(i),1)        Then a = bitor(a,'10'x)
        When Abbrev("NODISPLAY",Arg(i),1)   Then a = bitor(a,'0C'x)
        When Abbrev("HIGH",Arg(i),1)        Then a = bitor(a,'08'x)
        When Abbrev("BLINK",Arg(i),3)       Then b = bitor(b,'01'x)
        When Abbrev("REVERSE",Arg(i),3)     Then b = bitor(b,'02'x)
        When Abbrev("UNDERLINE",Arg(i),1)   Then b = bitor(b,'04'x)
        When Abbrev("BLUE",Arg(i),3)        Then c = 'F1'x
        When Abbrev("RED",Arg(i),3)         Then c = 'F2'x
        When Abbrev("PINK",Arg(i),1)        Then c = 'F3'x
        When Abbrev("GREEN",Arg(i),1)       Then c = 'F4'x
        When Abbrev("TURQUOISE",Arg(i),1)   Then c = 'F5'x
        When Abbrev("YELLOW",Arg(i),1)      Then c = 'F6'x
        When Abbrev("WHITE",Arg(i),1)       Then c = 'F7'x
        Otherwise nop
        End  /*  Select  at  */
    i = i + 1
    End  /*  Do  While  */
 
If  ^fs.color   | ,
    ^fs.exthi   Then    Return '1D'x || bitor(a,'40'x)
                Else    Return '2902'x || ,
                               'C0'x   || bitor(a,'40'x) || ,
                               '42'x   || bitor(c,'40'x)
 
 
 
/* ---------------------------------------------------------------- GTAG
 *  Match the gopher data type to a national language  "tag"  string.
 */
GTAG:     Procedure
 
Parse Arg type
 
    Select  /*  type  */
 
        When type = '0' Then _tag = 700
        When type = '1' Then _tag = 701
        When type = '2' Then _tag = 702
        When type = '3' Then _tag = 703
        When type = '4' Then _tag = 704
        When type = '5' Then _tag = 705
        When type = '6' Then _tag = 706
        When type = '7' Then _tag = 707
        When type = '8' Then _tag = 708
        When type = '9' Then _tag = 709
        When type = 's' Then _tag = 767
        When type = 'r' Then _tag = 766
        When type = 'v' Then _tag = 770
        When type = 'i' Then _tag = 757
        When type = 'I' Then _tag = 725
        When type = 'g' Then _tag = 755
        When type = 'M' Then _tag = 729
        When type = 'T' Then _tag = 736
 
        When type = ':' Then _tag = 710
        When type = ';' Then _tag = 711
        When type = '<' Then _tag = 712
 
        When type = 'F' Then _tag = 722
 
        Otherwise            _tag = 908
 
        End  /*  Select  type  */
 
'CALLPIPE COMMAND XMITMSG' _tag 'TYPE (APPLID GOP NOHEADER | VAR TAG'
 
Return tag
 
 
 
/* ---------------------------------------------------------------- HELP
 *  Invoke CMS HELP for GOPHER BROWSER (the menu browser).
 */
HELP:     Procedure Expose fs. message.
 
If fs.tube ^= "" Then
    'CALLPIPE COMMAND HELP GOPHER BROWSER (ALL NOSCREEN' ,
        '| GOPCLIFV BROWSER HELP' ,
            '| STEM MESSAGE. APPEND'
 
Else Do
    Address "COMMAND" 'HELP GOPHER BROWSER'
    Address "COMMAND" 'VMFCLEAR'
    End  /*  Else  Do  */
 
Return
 
