/*
 *        Name: GOPCLIPI REXX
 *              VM TCP/IP Network GOPHER Client panel input stage
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1993-Mar-29
 *
 *       Input: a "stanza file" with feedback field definitions
 *      Output: the user's response(s),  lines of  field=response
 */
 
/*  fetch fs. stem variable from GlobalV environment  */
'CALLPIPE COMMAND GLOBALV SELECT GOPHER LIST | DROP' ,
        '| LOCATE 1.4 / FS./ | CHANGE 1.1 / /=/1 | VARLOAD'
If ^Datatype(fs.tube,'X') Then fs.tube = ""
 
i = 0
r = 0
c = 0
w = 8
 
Do Forever
 
    'READTO RECORD'     /*  go ahead and eat the record  */
    If rc ^= 0 Then Leave
    If Left(record,1) = '*' Then Iterate
    If Strip(record) = "" Then Iterate
 
    Parse Upper Var record key .
    If Right(key,1) = ':' Then Do
 
        If Datatype(finput.i.ROW,'N') Then r = finput.i.ROW + 1
        If Datatype(finput.i.COL,'N') Then c = finput.i.COL
        /*  let width default to most of screen/window width  */
        If Datatype(finput.i.WID,'N') Then w = fs.scrcols - c - 1
        i = i + 1
        Parse Var key key ':' .
        finput.i = key
        finput.i.ROW = r        /*  row position of this field  */
        finput.i.COL = c        /*  column position of this field  */
        finput.i.WID = w        /*  width in characters of field  */
        finput.i.PRE = ""       /*  prefix/prompt  */
        finput.i.TXT = ""       /*  default field contents  */
        finput.i.SUF = ""       /*  suffix  */
        finput.i.PRO = 0        /*  protected?  */
        Iterate
 
        End  /*  If  ..  Do  */
 
    Else Do
 
        Parse Upper Var record var '='  .
        var = Strip(var)
        Parse       Var record  .  '=' val
        val = Strip(val)
 
        If i = 0 Then Do
 
            If Abbrev("PROCESS",var,4)  Then process = val
            If Abbrev("SUBJECT",var,4)  Then subject = val
            If Abbrev("TITLE",var,1)    Then title = val
 
            End  /*  If  ..  Do  */
 
        Else
        Select  /*  var  */
 
            When Abbrev("ROW",var,3)    Then finput.i.ROW = val
            When Abbrev("COLUMN",var,3) Then finput.i.COL = val
            When Abbrev("WIDTH",var,3)  Then finput.i.WID = val
            When Abbrev("PROMPT",var,3) Then finput.i.PRE = val
            When Abbrev("PREFIX",var,3) Then finput.i.PRE = val
            When Abbrev("STRING",var,3) Then finput.i.TXT = val
            When Abbrev("SUFFIX",var,3) Then finput.i.SUF = val
            When Abbrev("TYPE",var,4)   Then Do
                Upper val
                If Index(val,"READONLY") Then finput.i.PRO = 1
                End  /*  When  ..  Do  */
            Otherwise nop
 
            End  /*  Select  var  */
 
        End  /*  If  ..  Do  */
 
    End  /*  Do  Forever  */
 
If rc ^= 0 & rc ^= 12 Then Exit rc
 
finput.0 = i
screen = 'C0'x || 'C3'x
 
Do i = 1 To finput.0
 
    r = finput.i.ROW
    c = finput.i.COL
    w = finput.i.WID
    p = finput.i.PRE
    s = finput.i.TXT
    q = finput.i.SUF
 
    w = Max(w,Length(s))
    s = Left(s,w,'00'x)
 
    screen = screen ,
        || sba(r,c-Length(p)-2) || field("PROT","GREEN") || p
If finput.i.PRO Then
    screen = screen ,
        || field("PROT","WHITE")
Else
    screen = screen ,
        || field("HIGH","WHITE")
If i = 1 Then
    screen = screen ,
        || '13'x
    screen = screen ,
        || s || field("PROT","GREEN") || q
 
    End  /*  Do  For  */
 
Address "COMMAND" 'VMFCLEAR'
 
Do Forever
 
    'CALLPIPE VAR SCREEN | FULLSCR' fs.tube ,
        'PATH' gopher 'NOCLOSE | VAR RS'
    Parse Var rs With 1 aid 2 cursor 4 rs
 
    Select  /*  aid  */
 
        When aid = '6D'x Then Iterate
        When aid = 'F5'x Then Call PROCESS
        When aid = '7D'x Then Call PROCESS
        Otherwise nop
 
        End  /*  Select  aid  */
 
    Leave
 
    End  /*  Do  Forever  */
 
Exit
 
 
 
/* ------------------------------------------------------------- PROCESS
 */
PROCESS:
 
'ADDPIPE *.OUTPUT: |' process '| *:'
 
Parse Var rs . 2 rs
Do While rs ^= ""
    Parse Var rs 1 offset 3 string '11'x rs
    If bitand(offset,'C000'x) ^= '0000'x Then
            offset = c2d(bitand(offset,'3F00'x)) / 4 ,
                   + c2d(bitand(offset,'003F'x))
    Else    offset = c2d(offset)
    r = offset % fs.scrcols
    c = offset // fs.scrcols
    Do i = 1 to finput.0
        If  finput.i.ROW = r  & ,
            finput.i.COL = c  Then
                'OUTPUT' finput.i || '=' || string
        End  /*  Do  For  */
    End  /*  Do  While  */
 
 
 
Return
 
 
 
/* ----------------------------------------------------------------- SBA
 * (a better SBA function extracted from PIPEDEMO; thanks, Chuck!)
 * Construct Set Buffer Address order from row and column.
 */
 
SBA:      Procedure Expose fs.
 
Parse Arg row, col
row = Trunc(row)
col = Trunc(col)
 
/*-----------------------------------------------------------------*/
/* Calculate binary address.                                       */
/*-----------------------------------------------------------------*/
 
offset = row * fs.scrcols + col
Do While offset < 0; offset = offset + fs.scrrows * fs.scrcols; End
 
if fs.14bit then return '11'x || d2c(offset,2)
 
/*-----------------------------------------------------------------*/
/* Convert to six-bit format. (xxxx111111111111 -> 0011111100111111*/
/*-----------------------------------------------------------------*/
 
'CALLPIPE var offset'               ,   /* Start with char number.    */
    '| spec 1-* d2c 1.2 right'      ,   /* Convert to binary.         */
    '| spec 1-* c2b 1'              ,   /* Convert to bit string.     */
    '| spec /00/ 1  5.6  3'         ,   /* Place first six bits.      */
           '/00/ 9 11.6 11'         ,   /* Place second six bits.     */
    '| spec 1-* b2c 1'              ,   /* Convert back to binary.    */
    '| xlate *-* 00-3F 40-7F'       ,   /* Translate to coded         */
                '01-09 C1-C9'       ,   /*   buffer address.          */
                '11-19 D1-D9'       ,   /*                            */
                '22-29 E2-E9'       ,   /*                            */
                '30-39 F0-F9'       ,   /*                            */
    '| spec x11 1 1.2 2'            ,   /* Prefix with SBA order.     */
    '| var offset'                      /* Put back in variable.      */
 
Return offset
 
 
 
/* --------------------------------------------------------------- FIELD
 * Generate the 3270 DS sequence for extended field attributes
 * (if available).
 */
FIELD:    Procedure Expose fs.
a = '00'x
b = '00'x
c = 'F1'x
i = 1
Do While Arg(i) ^= ""
    Select  /*  at  */
        When Abbrev("PROTECTED",Arg(i),2)   Then a = bitor(a,'20'x)
        When Abbrev("SKIP",Arg(i),1)        Then a = bitor(a,'10'x)
        When Abbrev("NODISPLAY",Arg(i),1)   Then a = bitor(a,'0C'x)
        When Abbrev("HIGH",Arg(i),1)        Then a = bitor(a,'08'x)
        When Abbrev("BLINK",Arg(i),3)       Then b = bitor(b,'01'x)
        When Abbrev("REVERSE",Arg(i),3)     Then b = bitor(b,'02'x)
        When Abbrev("UNDERLINE",Arg(i),1)   Then b = bitor(b,'04'x)
        When Abbrev("BLUE",Arg(i),3)        Then c = 'F1'x
        When Abbrev("RED",Arg(i),3)         Then c = 'F2'x
        When Abbrev("PINK",Arg(i),1)        Then c = 'F3'x
        When Abbrev("GREEN",Arg(i),1)       Then c = 'F4'x
        When Abbrev("TURQUOISE",Arg(i),1)   Then c = 'F5'x
        When Abbrev("YELLOW",Arg(i),1)      Then c = 'F6'x
        When Abbrev("WHITE",Arg(i),1)       Then c = 'F7'x
        Otherwise nop
        End  /*  Select  at  */
    i = i + 1
    End  /*  Do  While  */
 
If  ^fs.color   | ,
    ^fs.exthi   Then    Return '1D'x || bitor(a,'40'x)
                Else    Return '2902'x || ,
                               'C0'x   || bitor(a,'40'x) || ,
                               '42'x   || bitor(c,'40'x)
 
/*
 *      Copyright 1993 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
 
 
 
 
 
 
 
 
 
Address "COMMAND" 'GLOBALV SELECT GOPHER GET' ,
        'GOPHER PROGID ITEM'
quit = 0
 
Parse Var item name '05'x path '05'x host '05'x port '05'x xtra
Parse Var name 1 . 2 name       /*  discard type indicator byte  */
Parse Var path 1 . 2 path       /*  discard type indicator byte  */
 
/*  display the menu and process user's response  */
row = 0;        col = 0         /*  reset later  */
kn = menu.0;    kl = fs.scrrows - 5;    ko = 1
command = ""
 
'CALLPIPE COMMAND XMITMSG 616 (APPLID GOP' ,
        'CALLER CLI NOCOMP | SPEC WORD 2-* 1 | STEM PFKEYS.'
 
'CALLPIPE COMMAND XMITMSG 5 (APPLID GOP NOHEADER | VAR MORE'
 
Do Forever
 
    /*  write the program title line  */
    wscreen = sba(0,-1) || field("BLUE","PROT") || sba(0,0) || progid ,
                        || sba(0,fs.scrcols-Length(host)-1) || host
 
    /*  no SBA for status because it follows host immediately  */
    If message.0 < 1 Then Do
    wscreen = wscreen   || field("PROT") || Left(ko || '/' || ki, 11)
    If ko + kl <= ki Then
    wscreen = wscreen   || field("WHITE","HIGH","PROT") || more
        End  /*  If  ..  Do  */
 
    /*  don't write status or name if they'll be overlaid  */
    If message.0 < 2 Then
    wscreen = wscreen   || sba(2,(fs.scrcols-Length(name))/2) ,
                        || field("WHITE","PROT") || name
 
    /*  write as many message lines as needed  */
    If message.0 > 0 Then Do
        Do i = 1 to message.0
            wscreen = wscreen || sba(i,-1) ,
                || field("RED","HIGH","PROT") || message.i
            End  /*  Do  For  */
        message.0 = 0
        End  /*  If  ..  Do  */
    /*  we should probably limit that count  */
 
    /*  write those PFkey settings  */
    wscreen = wscreen   || sba(fs.scrrows-2,-1) ,
                        || field("BLUE","PROT") ,
                        || help.1 ,
                        || sba(fs.scrrows-1,-1) ,
                        || field("BLUE","PROT") ,
                        || help.2
 
    i = 1; j = ko
    Do While i <= kl & j <= ki
 
        Parse Var menu.j _name '05'x .
        Parse Var _name 1 _type 2 _name
        'CALLPIPE VAR _NAME | XLATE OUTPUT' ,
            '| XLATE *-* 00-3F 40 FF 40 | VAR _NAME'
 
        wscreen = wscreen || sba(i+2,-1) ,
                          || field("BLUE","PROT","HIGH")
        If _type = 'i' Then
        wscreen = wscreen || Left(_name,fs.scrcols-1)
                      Else Do
        wscreen = wscreen || Left(gtag(_type),11) ,
                          || field("GREEN") ,
                          || Left(_name,fs.scrcols-13)
            If row = 0 Then Do
                row = i + 2;    col = 12
                End  /*  If  ..  Do  */
            End  /*  Else  Do  */
 
        i = i + 1;  j = j + 1
 
        End  /*  Do  While  */
 
    rscreen = write_read(wscreen || sba(row,col) || '13'x)
    Parse Var rscreen 1 aid 2 offset . '11'x rscreen
    offset = fix(offset)
    row = offset % fs.scrcols; col = offset // fs.scrcols
 
    /*  keep the row/col values within bounds  */
    If  row      <   3       Then row = 3
    If  row      >   kl + 3  Then row = kl + 3
    If  row + ko >   ki + 3  Then row = ki + 3 - ko
    col = 12    /*  just reset it  */
 
    i = row + ko - 3
 
    Select /* aid */
        When  aid = '7D'x   /* enter */ | ,
              aid = 'F2'x   /*  PF2  */ | ,
              aid = 'C2'x   /*  PF14 */ | ,
              aid = '7B'x   /*  PF11 */ | ,
              aid = '4B'x   /*  PF23 */ Then  Call  OPEN
        When  aid = 'F3'x   /*  PF3  */ | ,
              aid = 'C3'x   /*  PF15 */ Then  Leave
        When  aid = 'F4'x   /*  PF4  */ | ,
              aid = 'C4'x   /*  PF16 */ Then  Call  PRINT
        When  aid = 'F5'x   /*  PF5  */ | ,
              aid = 'C5'x   /*  PF17 */ Then  Call  KEEP
        When  aid = 'F6'x   /*  PF6  */ | ,
              aid = 'C6'x   /*  PF18 */ Then  Call  FIND
        When  aid = 'F7'x   /*  PF7  */ | ,
              aid = 'C7'x   /*  PF19 */ Then Do
            ko = Max(ko-kl+1,1)
            row = 3
            End  /*  When  ..  Do  */
        When  aid = 'F8'x   /*  PF8  */ | ,
              aid = 'C8'x   /*  PF20 */ Then Do
            ko = Min(ko+kl-1,ki)
            row = 3
            End  /*  When  ..  Do  */
        When  aid = 'F9'x   /*  PF9  */ | ,
              aid = 'C9'x   /*  PF21 */ Then  Call  MARK
        When  aid = '7A'x   /*  PF10 */ | ,
              aid = '4A'x   /*  PF22 */ Then  Call  BOOKLIST
        When  aid = '6D'x   /* clear */ | ,
              aid = '6E'x   /*  PA2  */ Then Do
            row = 3;    col = 12;   ko = 1
            End  /*  When ..  Do  */
        When  aid = '7C'x   /*  PF12 */ | ,
              aid = '4C'x   /*  PF24 */ | ,
              aid = 'F0'x   /* sysrq */ | ,
              aid = '6C'x   /*  PA1  */ Then  quit = 1
        When  aid = 'F1'x   /*  PF1  */ | ,
              aid = 'C1'x   /*  PF13 */ Then  Call  HELP
        When  aid = '00'x               Then Do
            /*  I/O error on screen  */
            'CALLPIPE COMMAND XMITMSG 925 (APPLID GOP' ,
                    'CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
            Leave
            End
        Otherwise  Do   /*  Undefined PFkey/PAkey  */
            'CALLPIPE COMMAND XMITMSG 657 "' || c2x(aid) || '"' ,
                '(APPLID GOP CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
            End  /*  Otherwise  Do  */
        End  /*  Select  aid  */
 
    Address "COMMAND" 'GLOBALV SELECT GOPHER GET COMMAND'
    Parse Upper Var command cmdverb .
    quit = (quit | Abbrev("QUIT",cmdverb,1))
 
    If quit Then Leave
 
    End  /*  Do  Forever  */
 
If quit Then command = "QUIT"
 
'CALLPIPE STEM MESSAGE. | *:'
 
Parse Upper Var command cmdverb .
Address "COMMAND" 'GLOBALV SELECT GOPHER PUT' ,
        'COMMAND CMDVERB'
 
Exit
 
 
 
/* ---------------------------------------------------------------- OPEN
 */
OPEN:
 
'CALLPIPE VAR MENU.' || i '| GOPCLITM OPEN | STEM MESSAGE. APPEND'
 
Return
 
 
 
/* --------------------------------------------------------------- PRINT
 * Print the current "menu" on the user's virtual printer.
 */
PRINT:
 
If fs.tube ^= "" Then Do
    /*  "Can't PRINT from this terminal."  */
    'CALLPIPE COMMAND XMITMSG 507 (APPLID GOP CALLER CLI ERRMSG' ,
            '| STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
'CALLPIPE STEM MENU. | XLATE *-* 05 7A' ,
        '| PRINT (TITLE' name '| STEM MESSAGE. APPEND'
 
Return
 
 
 
/* ---------------------------------------------------------------- KEEP
 */
KEEP:
 
'CALLPIPE VAR MENU.' || i '| GOPCLITM KEEP | STEM MESSAGE. APPEND'
 
Return
 
 
 
/* ---------------------------------------------------------------- MARK
 *  Save a bookmark referencing this feedback item.
 */
MARK:
 
If fs.tube ^= "" Then Do
    /*  "Can't set bookmarks from this screen."  */
    'CALLPIPE COMMAND XMITMSG 43 (APPLID GOP CALLER CLI ERRMSG' ,
            '| STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
If booklist Then Do
    'CALLPIPE COMMAND XMITMSG 42 I (APPLID GOP NOHEADER' ,
        '| SPEC /i            / 1 1-* NEXT | VAR BOOKMARK.' || i
    If rc = 0 Then
    Address "COMMAND" 'GLOBALV SELECT GOPHER PUTP BOOKMARK.' || i
    If rc = 0 Then 'CALLPIPE COMMAND XMITMSG 42 I' ,
        '(APPLID GOP CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
        /*  "Bookmark" i "deleted."  */
    Else 'CALLPIPE COMMAND XMITMSG 514 RC "GLOBALV"' ,
        '(APPLID GOP CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
    Return
    End /* If .. Do */
 
Address "COMMAND" 'GLOBALV SELECT GOPHER GET BOOKMARK.0'
If ^Datatype(bookmark.0,'N') Then bookmark.0 = 0
i = bookmark.0 + 1
bookmark.i = item
Address "COMMAND" 'GLOBALV SELECT GOPHER PUTP BOOKMARK.' || i
bookmark.0 = i
Address "COMMAND" 'GLOBALV SELECT GOPHER PUTP BOOKMARK.0'
 
If rc = 0 Then 'CALLPIPE COMMAND XMITMSG 41 I' ,
    '(APPLID GOP CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
    /*  "Bookmark" i "saved."  */
          Else 'CALLPIPE COMMAND XMITMSG 514 RC "GLOBALV"' ,
        '(APPLID GOP CALLER CLI ERRMSG | STEM MESSAGE. APPEND'
 
Return
 
 
 
/* ------------------------------------------------------------ BOOKLIST
 *  Call GOPCLI to show the lit of bookmarks.
 */
BOOKLIST:
 
Address "CMS" 'GOPCLI (BOOKLIST'
 
Return
 
 
 
/* ----------------------------------------------------------------- FIX
 * Takes an inbound 3270 DS screen address (two bytes)
 * and returns the equivalent byte offset in decimal.
 */
FIX:
Parse Arg o,.
Parse Var o 1 o1 2 o2 3 .
o1 = c2d(o1)
o2 = c2d(o2)
If o1 < 64 Then Return o1 * 256 + o2
           Else Return (o1 // 64) * 64 + (o2 // 64)
 
 
 
/* ---------------------------------------------------------------- HELP
 *  Invoke CMS HELP for GOPHER FEEDBACK (feedback panel).
 */
HELP:     Procedure Expose fs. message.
 
If fs.tube ^= "" Then
    'CALLPIPE COMMAND HELP GOPHER BROWSER (ALL NOSCREEN' ,
        '| GOPCLIFV BROWSER HELP' ,
            '| STEM MESSAGE. APPEND'
 
Else Do
    Address "COMMAND" 'HELP GOPHER BEEDBACK'
    Address "COMMAND" 'VMFCLEAR'
    End  /*  Else  Do  */
 
Return
 
