/*
 *        Name: GOPCLIST REXX
 *              VM TCP/IP Network GOPHER Client transaction status
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1993-Jan-12
 *
 *       Input: zero or more connection status messages
 *      Output: -none-
 */
 
/*
 *      Copyright 1992 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
Trace "OFF"
 
/*  sync with input  */
'PEEKTO'
If rc ^= 0 Then Exit rc * (rc ^= 12)
 
Address "COMMAND" 'GLOBALV SELECT GOPHER GET GOPHER'
 
/*  fetch fs. stem variable from GlobalVs  */
'CALLPIPE COMMAND GLOBALV SELECT GOPHER LIST | DROP' ,
        '| LOCATE 1-4 / FS./ | SPEC /=/ 1 2-* NEXT | VARLOAD'
If fs.conbug Then Exit
If ^Datatype(fs.tube,'X') Then fs.tube = ""
 
/*  prepare for dynamic connection statistics  */
_wid = fs.scrcols - 2
_sba = c2x(sba(1,-1) || '1D60'x)
 
'CALLPIPE *: | CHOP ' _wid '| PAD' _wid ,
        '| SPEC /00C3' || _sba || '/ X2C 1 1-* NEXT' ,
            '| FULLSCR' fs.tube 'NOREAD' ,
                'PATH' gopher 'NOCLOSE | HOLE'
 
Exit rc
 
 
 
/* ----------------------------------------------------------------- SBA
 *  (a better SBA function extracted from PIPEDEMO; thanks, Chuck!)
 *  Construct Set Buffer Address order from row and column.
 */
 
SBA:      Procedure Expose fs.
 
arg row , col, .
row = Trunc(row)
col = Trunc(col)
 
/*-----------------------------------------------------------------*/
/* Calculate binary address.                                       */
/*-----------------------------------------------------------------*/
 
offset = row * fs.scrcols + col
Do While offset < 0; offset = offset + fs.scrrows * fs.scrcols; End
 
if fs.14bit then return '11'x || d2c(offset,2)
 
/*-----------------------------------------------------------------*/
/* Convert to six-bit format. (xxxx111111111111 -> 0011111100111111*/
/*-----------------------------------------------------------------*/
 
'CALLPIPE var offset'               ,   /* Start with char number.    */
    '| spec 1-* d2c 1.2 right'      ,   /* Convert to binary.         */
    '| spec 1-* c2b 1'              ,   /* Convert to bit string.     */
    '| spec /00/ 1  5.6  3'         ,   /* Place first six bits.      */
           '/00/ 9 11.6 11'         ,   /* Place second six bits.     */
    '| spec 1-* b2c 1'              ,   /* Convert back to binary.    */
    '| xlate *-* 00-3F 40-7F'       ,   /* Translate to coded         */
                '01-09 C1-C9'       ,   /*   buffer address.          */
                '11-19 D1-D9'       ,   /*                            */
                '22-29 E2-E9'       ,   /*                            */
                '30-39 F0-F9'       ,   /*                            */
    '| spec x11 1 1.2 2'            ,   /* Prefix with SBA order.     */
    '| var offset'                      /* Put back in variable.      */
 
Return offset
 
