/*
 *        Name: GOPCLITM REXX
 *              VM TCP/IP Network GOPHER Client item processor
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1992-Dec-23
 *
 *       Input: one or more gopher menu lines
 *      Output: zero or more information or error messages
 *              (EOF does not propagate back to input)
 */
 
/*
 *      Copyright 1992 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
Trace "OFF"
 
Parse Upper Arg disp . '(' . ')' .
If disp = "" Then disp = "OPEN"
/*  Say open  */
 
/*  sync with input so that 'CALLPIPE COMMAND' will work  */
'PEEKTO'
 
'CALLPIPE COMMAND GLOBALV SELECT GOPHER GET GOPHER PROGID'
 
/*  fetch fs. stem variable from GlobalVs  */
'CALLPIPE COMMAND GLOBALV SELECT GOPHER LIST | DROP' ,
        '| LOCATE 1-4 / FS./ | SPEC /=/ 1 2-* NEXT | VARLOAD'
If ^Datatype(fs.tube,'X') Then fs.tube = ""
 
/*  prepare for dynamic connection statistics  */
stat = 'STEM STAT. | GOPCLIST'
 
Do Forever
 
    'PEEKTO ITEM'
    If rc ^= 0 Then Leave
 
    'CALLPIPE COMMAND GLOBALV SELECT GOPHER PUT ITEM'
 
    Parse Var item name '05'x path '05'x host '05'x port '05'x xtra
    Parse Var name 1 type 2 name
 
stat.0 = 0
 
    Select  /*  type  */
 
        When  type = '0'  Then  Call  OPENFILE
 
        When  type = '1'  Then  Call  OPENMENU
 
        When  type = '2'  Then  Call  LOOKUP
 
        When  type = '4'  Then  Call  OPENFILE  /* MAC */
 
        When  type = '5'  Then  Call  BINARY    /* DOS */
 
        When  type = '6'  Then  Call  OPENFILE  /* UUE */
 
        When  type = '7'  Then  Call  SEARCH
 
        When  type = '8'  Then  Call  TELNET
 
        When  type = '9'  Then  Call  BINARY
 
        When  type = 'T'  Then  Call  TN3270
 
        When  type = 'r'  | ,
              type = 'v'  Then  Call  CMSBLOCK
 
        When  type = 'I'  | ,
              type = ':'  | ,
              type = 'g'  Then  Call  GRAPHICS
 
        When  type = 'F'  Then  Call  FEEDBACK
 
        When  type = 'M'  Then  Call  OPENMIME
 
        When  type = 'i'  Then  nop  /*  Panda "info",  do nothing  */
 
        Otherwise               Call  OPENFILE
 
        End  /*  Select  type  */
 
If rc ^= 0 Then 'CALLPIPE STEM STAT. | *:'
 
    'READTO'
 
    End  /*  Do  Forever  */
 
Exit rc * (rc ^= 12)
 
 
 
/* ------------------------------------------------------------ OPENFILE
 *  View or retrieve a plain text file.
 */
OPENFILE:
 
filter = 'GOPCLITX'
 
If disp = "KEEP" Then Signal KEEPFILE
 
'CALLPIPE (END !) VAR ITEM | E: GOPCLISX' ,
    '| GOPCLITX | GOPCLIFV | *:' ,
    '! E: |' stat
 
Return
 
 
 
/* ------------------------------------------------------------ OPENMENU
 *  View or retrieve a plain text file.
 */
OPENMENU:
 
filter = 'GOPCLITX'
 
If disp = "KEEP" Then Signal KEEPFILE
 
'CALLPIPE (END !) VAR ITEM | E: GOPCLISX' ,
    '| GOPCLITX | GOPCLIMB | *:' ,
    '! E: |' stat
 
Return
 
 
 
/* -------------------------------------------------------------- LOOKUP
 *  Perform user lookup.   (punt to PH EXEC or equivalent)
 */
LOOKUP:
 
host = Strip(host)
port = Strip(port)
'CALLPIPE COMMAND GLOBALV SELECT PHCMS PUT HOST PORT'
Address "CMS" 'PH'
 
Return
 
 
 
/* -------------------------------------------------------------- SEARCH
 */
SEARCH:
 
'CALLPIPE COMMAND XMITMSG 601 (APPLID GOP NOHEADER' ,
        '| GOPCLIUI | VAR KEYWORDS'
keywords = Strip(keywords)
If keywords = "" Then Return
 
/*  prepend a  path<TAB>  to search string for WAIS servers  */
/*  path = path || '05'x || keywords  */
item = item || '05'x || keywords
 
'CALLPIPE (END !) VAR ITEM | E: GOPCLISX' ,
    '| GOPCLITX | GOPCLIMB | *:' ,
    '! E: |' stat
 
Return
 
 
 
/* -------------------------------------------------------------- TELNET
 */
TELNET:
 
If fs.tube ^= "" Then Do
    /*  'OUTPUT' "Can't TELNET from this screen"  */
    'CALLPIPE COMMAND XMITMSG 512 "TELNET"' ,
            '(APPLID GOP CALLER CLI ERRMSG | *:'
    Return
    End /* If .. Do */
 
Address "COMMAND"
 
host = Strip(host);     port = Strip(port)
 
'VMFCLEAR'
If port = 0 Then port = ""
/*  Say progid "TELNET" host port  */
'XMITMSG 30 HOST PORT (APPLID GOP CALLER CLI ERRMSG'
/*  Say name  */
'XMITMSG 7 NAME (APPLID GOP CALLER CLI ERRMSG NOCOMP'
 
If path ^= "" Then Do
    /*  Say "login with:" path  */
    'XMITMSG 32 PATH (APPLID GOP CALLER CLI NOHEADER'
    /*  Say "Press ENTER to continue ... "  */
    'XMITMSG 33 (APPLID GOP CALLER CLI NOHEADER'
    Parse External
    End  /*  If  ..  Do  */
 
'GLOBALV SELECT GOPHER GET TELNET'
If telnet = "" Then telnet = "TELNET"
Address "CMS" telnet host port
'VMFCLEAR'
 
Address
 
Return
 
 
 
/* -------------------------------------------------------------- BINARY
 *  Load a "binary" (byte stream) file onto disk.
 */
BINARY:
 
filter = ""
 
If disp = "KEEP" Then Signal KEEPFILE
 
'CALLPIPE (END !) VAR ITEM | E: GOPCLISX' ,
    '| GOPCLIFV | *:' ,
    '! E: |' stat
 
Return
 
 
 
/* -------------------------------------------------------------- TN3270
 *  This is almost exactly the same as the  TELNET  routine,
 *  but we let the user run a different program,  specified in
 *  global variable  TN3270,  if they wish.
 */
TN3270:
 
If fs.tube ^= "" Then Do
    /*  'OUTPUT' "Can't TN3270 from this screen"  */
    'CALLPIPE COMMAND XMITMSG 512 "TN3270"' ,
            '(APPLID GOP CALLER CLI ERRMSG | *:'
    Return
    End /* If .. Do */
 
Address "COMMAND"
 
host = Strip(host);     port = Strip(port)
 
'VMFCLEAR'
If port = 0 Then port = ""
/*  Say progid "TN3270" host port  */
'XMITMSG 31 HOST PORT (APPLID GOP CALLER CLI ERRMSG'
/*  Say name  */
'XMITMSG 7 NAME (APPLID GOP CALLER CLI ERRMSG NOCOMP'
If path ^= "" Then Do
    /*  Say "login with:" path  */
    'XMITMSG 32 PATH (APPLID GOP CALLER CLI NOHEADER'
    /*  Say "Press ENTER to continue ... "  */
    'XMITMSG 33 (APPLID GOP CALLER CLI NOHEADER'
    Parse External
    End  /*  If  ..  Do  */
 
'GLOBALV SELECT GOPHER GET TN3270'
If tn3270 = "" Then Do
    'GLOBALV SELECT GOPHER GET TELNET'
    If telnet = "" Then telnet = "TELNET"
    tn3270 = telnet
    End  /*  If  ..  Do  */
Address "CMS" tn3270 host port
'VMFCLEAR'
 
Address
 
Return
 
 
 
/* ------------------------------------------------------------ CMSBLOCK
 *  Save a record oriented file (type 'r' or type 'v') onto disk.
 */
CMSBLOCK:
 
filter = 'DEBLOCK CMS'
 
If disp = "KEEP" Then Signal KEEPFILE
 
'CALLPIPE (END !) VAR ITEM | E: GOPCLISX' ,
    '| DEBLOCK CMS | GOPCLIFV | *:' ,
    '! E: |' stat
 
Return
 
 
 
/* ------------------------------------------------------------ GRAPHICS
 *  Display or save a graphics (type 'I') file.
 */
GRAPHICS:
 
filter = ""     /*  same as for  "binary"  files  */
 
If disp = "KEEP" Then Signal KEEPFILE
 
'CALLPIPE (END !) VAR ITEM | E: GOPCLISX' ,
        '| GOPCLIGV | *: ! E: |' stat
 
Return
 
 
 
/* ------------------------------------------------------------ FEEDBACK
 *  View or retrieve a feedback form.
 */
FEEDBACK:
 
filter = 'GOPCLITX'
 
If disp = "KEEP" Then Signal KEEPFILE
 
'CALLPIPE (END !) VAR ITEM | E: GOPCLISX' ,
    '| GOPCLITX | GOPCLIPI | *:' ,
    '! E: |' stat
 
Return
 
 
 
/* ------------------------------------------------------------ OPENMIME
 *  View or retrieve a MIME type item.
 */
OPENMIME:
 
filter = 'GOPCLITX'
 
If disp = "KEEP" Then Signal KEEPFILE
 
'CALLPIPE STATE MIMEREAD REXX *'
If rc = 0 Then
'CALLPIPE (END !) VAR ITEM | E: GOPCLISX' ,
    '| GOPCLITX | MIMEREAD | *:' ,
    '! E: |' stat
Else
'CALLPIPE (END !) VAR ITEM | E: GOPCLISX' ,
    '| GOPCLITX | GOPCLIFV | *:' ,
    '! E: |' stat
 
Return
 
 
 
/* ------------------------------------------------------------ KEEPFILE
 *  Save the selected file on disk.
 */
KEEPFILE:
 
If fs.tube ^= "" Then Do
    'CALLPIPE COMMAND XMITMSG 508 (APPLID GOP CALLER CLI ERRMSG | *:'
    Return
    End  /*  If  ..  Do  */
 
Parse Var path 1 . 2 path    /*  discard type indicator  */
file = gopclifi(path)
'CALLPIPE CMS STATE' file 'A | VAR NOTFOUND'
If rc ^= 0 & rc ^= 28 Then 'CALLPIPE VAR NOTFOUND | *:'
If rc = 0 Then 'CALLPIPE COMMAND XMITMSG 594 FILE' ,
        '(APPLID GOP CALLER CLI ERRMSG | *:'
If rc ^= 28 Then Return
 
If filter = "" Then
'CALLPIPE (END !) VAR ITEM | E: GOPCLISX' ,
        '| >' file 'A' ,
        '! E: |' stat
Else
'CALLPIPE (END !) VAR ITEM | E: GOPCLISX' ,
        '|' filter '| >' file 'A' ,
        '! E: |' stat
 
If rc = 0 Then 'CALLPIPE COMMAND XMITMSG 571 FILE PATH' ,
        '(APPLID GOP CALLER CLI ERRMSG | *:'
/*  If rc = 0 Then errmsg = "Created" fn ft fm "from" path  */
 
Return
 
