/*
 *        Name: GOPCLITX REXX
 *              VM TCP/IP Network GOPHER Client plain-text processor
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1992-Dec-23
 *
 *       Input: raw ASCII text
 *      Output: plain (EBCDIC) text
 */
 
/*
 *      Copyright 1992 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
/*  Trace "OFF"  */
 
/*  sync with input so that 'CALLPIPE COMMAND' will work  */
'PEEKTO'
 
'CALLPIPE COMMAND GLOBALV SELECT GOPHER GET GOPHER'
If gopher = "" Then gopher = "Gopher"
 
'ADDPIPE *: | DEBLOCK LINEND 0A | DROP LAST 1' ,
        '| CHANGE' '000D002000'x '| TCPA2E' gopher '| *.INPUT:'
 
/*
 *        Name: DROPDOTS REXX
 *              drop trailing lines consisting of only "."
 *              (typically used for end-of-file indication)
 *        Date: 1992-Apr-18, 20
 */
 
dots = 0
'READTO LINE'
Do While rc = 0
    If Left(line,1) = "." Then Do
        dots = dots + 1
        line.dots = line
        End  /*  If  ..  Do  */
    Else Do
        Do i = 1 to dots;  'OUTPUT' line.i;  End
        dots = 0
        'OUTPUT' line
        End  /*  Else  Do  */
    'READTO LINE'
    End  /*  Do  While  */
 
Exit
 
