/*
 *        Name: GOPCLIUI REXX
 *              VM TCP/IP Network GOPHER Client user input
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1992-Dec-23
 *
 *       Input: a prompt string
 *      Output: the user's response
 *
 *              Untested with multiples,  but should work that way.
 */
 
/*
 *      Copyright 1992 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
Trace "OFF"
 
'PEEKTO'                /*  verify availability of input  */
If rc ^= 0 Then Exit rc * (rc ^= 12)
 
Address "COMMAND" 'GLOBALV SELECT GOPHER GET GOPHER'
 
/*  fetch fs. stem variable from calling REXX environment  */
'CALLPIPE REXXVARS 1 | DROP | JOIN 1 /,/' ,
        '| CHANGE /n /,/ | CHANGE /,v /,/ 1 | LOCATE /FS./ | VARLOAD'
 
/*  fetch current cursor position  */
If ^fs.conbug Then
    'CALLPIPE LITERAL 02 | SPEC 1-2 X2C 1' ,
        '| FULLSCR' fs.tube 'CONDREAD' ,
            'PATH' gopher 'NOCLOSE | VAR SCREEN'
Parse Var screen 1 aid 2 cursor 4 .
 
Do Forever
 
    'PEEKTO PROMPT'
    If rc ^= 0 Then Leave
 
    Parse Var prompt prompt ';' preset
    prompt = Strip(prompt)
    preset = Strip(preset)
 
    /* --------------------------------------------------------- GPROMPT
     *  Present a prompt and read from the Gopher user's screen.
     *  Preset response data may have been supplied.
     */
 
    If fs.conbug Then   /*  trouble with plain write  */  ,
            _write = fs.write || 'C3'x
    Else    _write =  '00'x  ||  'C3'x
    prompt = _write || sba(1,-1) || field("PROT","GREEN") || prompt ,
            || field("HIGH","WHITE") || '13'x || preset || ,
            Copies('00'x,fs.scrcols*2-Length(prompt)-Length(preset)-4) ,
            || field("PROT")
 
    'CALLPIPE VAR PROMPT | FULLSCR' fs.tube ,
        'PATH' gopher 'NOCLOSE | VAR RS'
    Parse Var rs With 1 aid 2 . 4 rs
 
    If  aid = '7D'x   /* enter */   Then Do
        Parse Var rs With . '11'x rs
        rs = Substr(rs,3)
        If rs = "" Then rs = preset
        'OUTPUT' rs
        End  /*  If  ..  Do  */
 
    Else 'OUTPUT'
 
    If ^fs.conbug Then
    'CALLPIPE VAR CURSOR | SPEC /00C311/ X2C 1 1.2 NEXT' ,
            '/13/ X2C NEXT | FULLSCR' fs.tube 'NOREAD' ,
                'PATH' gopher 'NOCLOSE | HOLE'
 
    'READTO'
 
    End  /*  Do  Forever  */
 
Exit rc * (rc ^= 12)
 
 
 
 
/* ----------------------------------------------------------------- SBA
 * (a better SBA function extracted from PIPEDEMO; thanks, Chuck!)
 * Construct Set Buffer Address order from row and column.
 */
 
SBA:      Procedure Expose fs.
 
arg row , col, .
row = Trunc(row)
col = Trunc(col)
 
/*-----------------------------------------------------------------*/
/* Calculate binary address.                                       */
/*-----------------------------------------------------------------*/
 
offset = row * fs.scrcols + col
Do While offset < 0; offset = offset + fs.scrrows * fs.scrcols; End
 
if fs.14bit then return '11'x || d2c(offset,2)
 
/*-----------------------------------------------------------------*/
/* Convert to six-bit format. (xxxx111111111111 -> 0011111100111111*/
/*-----------------------------------------------------------------*/
 
'CALLPIPE var offset'               ,   /* Start with char number.    */
    '| spec 1-* d2c 1.2 right'      ,   /* Convert to binary.         */
    '| spec 1-* c2b 1'              ,   /* Convert to bit string.     */
    '| spec /00/ 1  5.6  3'         ,   /* Place first six bits.      */
           '/00/ 9 11.6 11'         ,   /* Place second six bits.     */
    '| spec 1-* b2c 1'              ,   /* Convert back to binary.    */
    '| xlate *-* 00-3F 40-7F'       ,   /* Translate to coded         */
                '01-09 C1-C9'       ,   /*   buffer address.          */
                '11-19 D1-D9'       ,   /*                            */
                '22-29 E2-E9'       ,   /*                            */
                '30-39 F0-F9'       ,   /*                            */
    '| spec x11 1 1.2 2'            ,   /* Prefix with SBA order.     */
    '| var offset'                      /* Put back in variable.      */
 
Return offset
 
 
 
/* --------------------------------------------------------------- FIELD
 * Generate the 3270 DS sequence for extended field attributes
 * (if available).
 */
FIELD:    Procedure Expose fs.
a = '00'x
b = '00'x
c = 'F1'x
i = 1
Do While Arg(i) ^= ""
    Select  /*  at  */
        When Abbrev("PROTECTED",Arg(i),2)   Then a = bitor(a,'20'x)
        When Abbrev("SKIP",Arg(i),1)        Then a = bitor(a,'10'x)
        When Abbrev("NODISPLAY",Arg(i),1)   Then a = bitor(a,'0C'x)
        When Abbrev("HIGH",Arg(i),1)        Then a = bitor(a,'08'x)
        When Abbrev("BLINK",Arg(i),3)       Then b = bitor(b,'01'x)
        When Abbrev("REVERSE",Arg(i),3)     Then b = bitor(b,'02'x)
        When Abbrev("UNDERLINE",Arg(i),1)   Then b = bitor(b,'04'x)
        When Abbrev("BLUE",Arg(i),3)        Then c = 'F1'x
        When Abbrev("RED",Arg(i),3)         Then c = 'F2'x
        When Abbrev("PINK",Arg(i),1)        Then c = 'F3'x
        When Abbrev("GREEN",Arg(i),1)       Then c = 'F4'x
        When Abbrev("TURQUOISE",Arg(i),1)   Then c = 'F5'x
        When Abbrev("YELLOW",Arg(i),1)      Then c = 'F6'x
        When Abbrev("WHITE",Arg(i),1)       Then c = 'F7'x
        Otherwise nop
        End  /*  Select  at  */
    i = i + 1
    End  /*  Do  While  */
 
If  ^fs.color   | ,
    ^fs.exthi   Then    Return '1D'x || bitor(a,'40'x)
                Else    Return '2902'x || ,
                               'C0'x   || bitor(a,'40'x) || ,
                               '42'x   || bitor(c,'40'x)
 
