#!/usr/local/bin/perl
 
# gophercat - grab a single file from a Gopher server
#
# usage:  gophercat host port path
#
# Gophercat can handle both text and binary data types (binary types
# include both type "9" binaries and others such as type "I" images).  If
# the path does not include an initial type selector character followed
# by a "/", gophercat will assume type "0" (for text) and supply them.
# In text mode, gophercat will convert final CRLF to LF.  The path will
# need to be enclosed in quotation marks if it contains blanks or special
# characters.
#
# Among other uses, gophercat can be called from cron to do automatic
# mirroring of selected data files from a remote Gopher server.
#
# Examples:
#   gophercat gopher.micro.umn.edu 70 "0/Information About Gopher/.about"
#   gophercat wx.atmos.uiuc.edu 70 Forecast/City_Forecasts/US/TX/Houston-Hobby
#   gophercat cwis.rice.edu 70 I/MoreAbout/gopherT.gif
#
#----------------------------------------------------------------------------
# History:
# 12/16/92 PASR  Original version, but based on gopherclone by Bob Alberti
#                (alberti@boombox.micro.umn.edu) and friends:
#                   original NNTP client suggested by eci386!clewis
#                   socket code by cmf@obie.cis.pitt.edu (Carl M. Fongheiser)
#                   adaptation for gopher by emv@msen.com (Edward Vielmetti)
#                   mods to indexer by Bob Alberti
#----------------------------------------------------------------------------
 
$host = $ARGV[0];
$port = $ARGV[1];
$path = $ARGV[2];
 
# Make sure the path has an initial type selector (default "0/").
$path =~ s#^/?#0/# unless ($path =~ m#^./#);
 
$text = (substr($path, 0, 1) eq "0");   # treat like ASCII text?
 
if ($#ARGV == 2 && $host && $port && $path) {
   # Here's how to make your own socket.ph:
   #   cp /usr/include/sys/socket.h socket.h
   require 'socket.ph';  # h2ph socket
   chop($hostname = `hostname`);        # get host name in variable
 
   ($N) = &tcpconnect($host, $hostname);
 
   if ($N) {                    # If connection good
      send(N,"$path\r\n", 0) || die "Send $d to $host barfed with: $!\n";
      while (<N>) {
         last if /^\.\r\n$/;    # loop til lone period
         s#\r\n$#\n# if $text;  # change CRLF to LF if in text mode
         print "$_";            # print the line
      }
   } else {
      die "Couldn't open tcp connection $N: $!\n";
   }
   close(N);
} else {
   die "usage:  gophercat host port path\n";
}
 
 
sub tcpconnect {                    #Get TCP info in place
   local($host, $hostname) = @_;
   $sockaddr = 'S n a4 x8';
 
 
   ($name,$aliases,$proto) = getprotobyname('tcp');
   ($name,$aliases,$port) = getservbyname($port, 'tcp')
        unless $port =~ /^\d+$/;
   ($name,$aliases,$type,$len,$thisaddr) = gethostbyname($hostname);
   ($name,$aliases,$type,$len,$thataddr) = gethostbyname($host);
 
   $this = pack($sockaddr, &AF_INET, 0, $thisaddr);
   $that = pack($sockaddr, &AF_INET, $port, $thataddr);
 
   sleep(2);
 
   socket(N, &PF_INET, &SOCK_STREAM, $proto) || die "socket: $!";
   bind(N, $this)                            || die "bind: $!";
   connect(N, $that)                         || die "connect: $!";
 
   return(N);
}
