/*
 *        Name: GOPHERDH REXX
 *              pipeline stage for interpreting the CMS HELP database
 *      Author: Rick Troth, Rice Univ, I/S VM Systems Support
 *        Date: 1992-Apr-25, Jun-24
 *
 *              This gem is supplied with Rice CMS GopherD.
 */
 
Address "COMMAND" 'GLOBALV SELECT GOPHERD GET PATH NICK'
Say "GOPHERDH: PATH =" path
Say "GOPHERDH: NICK =" nick
 
/*  accept a command line;  remember options  */
Parse Upper Arg item '(' opts ')' .
Say "GOPHERDH:" item
 
/*  the "item" may have leading "path" parts,  which we just ignore   */
Do While Index(item,'/') > 0
    Parse Var item item '/' next
    If Strip(next) = "" Then Leave
    item = next
    End
Say "GOPHERDH:" item "(final)"
 
/*  make it right  */
If Words(item) = 0 Then item = "TASK HELP"
If Words(item) = 1 Then topic = "CMS"
                   Else Parse Var item topic item .
 
/*  is it a task? menu? or leaf item?  */
If item = "TASK" Then Do; item = topic; topic = "TASK"; End
If item = "MENU" Then Do; item = topic; topic = "MENU"; End
 
/*  call the right pipeline stages  */
Select  /*  topic  */
 
    When topic = "TASKTEXT" Then Call HELPTEXT
    When topic = "MENUTEXT" Then Call HELPTEXT
 
    When topic = "TASK" Then Call HELPTASK
/*      'CALLPIPE DISK' item 'HELPTASK * | HELPTASK' item '| *:'      */
 
    When topic = "MENU" Then CALL HELPMENU
/*      'CALLPIPE DISK' item 'HELPMENU * | HELPMENU' item '| *:'      */
 
    Otherwise                CALL HELPITEM
/*      'CALLPIPE COMMAND HELP' topic item '(NOSCREEN' opts '| *:'    */
 
    End  /*  Select  topic  */
 
Exit
 
 
 
/* ------------------------------------------------------------ HELPITEM
 */
HELPITEM:
 
'CALLPIPE COMMAND HELP' topic item '(NOSCREEN' opts '| *:'
 
Return
 
 
 
/* ------------------------------------------------------------ HELPTEXT
 */
HELPTEXT:
 
/*  it would be way-cool if we could present the preliminary text     *
 *  ("user instructions",  or whatever you want to call it)           *
 *  as a plain-text item from the menu we're creating here.           */
 
If topic = "MENUTEXT" Then 'ADDPIPE DISK' item 'HELPMENU * | *.INPUT:'
                      Else 'ADDPIPE DISK' item 'HELPTASK * | *.INPUT:'
 
/* read and replay displayed text or "user instructions" from task */
'PEEKTO LINE'
Do While rc = 0
    If Strip(line) = "" & Strip(prev) = "" Then Leave
 
    If Left(line,1) ^= '.' Then Do
        /* remove any HELP control sequences */
        p = Index(line,'4A'x)
        Do While p > 0
            line = Left(line,p-1) || Substr(line,p+2)
            p = Index(line,'4A'x)
            End
        /* and send this line of text down the pipe */
        'OUTPUT' line
        End
 
    prev = line
    'READTO'
    'PEEKTO LINE'
    End  /*  Do  While  */
 
Return
 
 
 
/* ------------------------------------------------------------ HELPTASK
 */
HELPTASK:
 
'ADDPIPE DISK' item 'HELPTASK * | *.INPUT:'
 
/* first consume the displayed text or "user instructions" */
'PEEKTO LINE'
Do While rc = 0
    If Strip(line) = "" & Strip(prev) = "" Then Leave
/*  If Left(line,1) ^= '.' Then 'OUTPUT' line  */
    prev = line
    'READTO'
    'PEEKTO LINE'
    End  /*  Do  While  */
 
'OUTPUT' "0" || item "task heading text" || '05'x || ,
         "0" || "TASKTEXT" item
 
/* now interpret the task lines and make a menu */
'PEEKTO LINE'
Do While rc = 0
    If Left(line,1) ^= '.' & Strip(line) ^= "" Then Do
        /* ignoring blank lines and control lines */
        Parse Var line 1 path 25 title
 
        /* remove HELP control sequences from titles */
        p = Index(title,'4A'x)
        Do While p > 0
            title = Left(title,p-1) || Substr(title,p+2)
            p = Index(title,'4A'x)
            End
 
        type = "0"
        Parse Upper Var path topic item .
        If item = "TASK" Then Do; item = topic; topic = "TASK"; End
        If item = "MENU" Then Do; item = topic; topic = "MENU"; End
        If topic = "TASK" | topic = "MENU" Then type = "1"
        'OUTPUT' type || title || '05'x || type || topic item
/*      'OUTPUT' type || title || '05'x || type || path               */
        End  /*  If  ..  Do  */
 
    'READTO'
    'PEEKTO LINE'
    End  /*  Do  While  */
 
Return
 
 
 
/* ------------------------------------------------------------ HELPMENU
 */
HELPMENU:
 
'ADDPIPE DISK' item 'HELPMENU * | *.INPUT:'
 
topic = item
 
'PEEKTO LINE'
Do While rc = 0
    If Strip(line) = "" & Strip(prev) = "" Then Leave
    prev = line
    'READTO'
    'PEEKTO LINE'
    End  /*  Do  While  */
 
'OUTPUT' "0" || item "menu heading text" || '05'x || ,
         "0" || "MENUTEXT" item
 
'PEEKTO LINE'
Do While rc = 0
    If Left(line,1) ^= '.' & Strip(line) ^= "" Then Do
        Parse Var line item .
        key = Left(item,1)
        Select  /*  key  */
            When key = '*' Then
                'OUTPUT' "1" || line || '05'x ||  ,
                    "1" || "MENU" Substr(item,2)
            When key = ':' Then
                'OUTPUT' "1" || line || '05'x || ,
                    "1" || "TASK" Substr(item,2)
            Otherwise
                'OUTPUT' "0" || line || '05'x || ,
                    "0" || topic item
            End  /*  Select  key  */
        End  /*  If  ..  Do  */
    'READTO'
    'PEEKTO LINE'
    End  /*  Do  While  */
 
Return
 
