/*
 *        Name: GOPHERDH REXX (GOPHERDI)
 *              pipeline stage for interpreting the CMS HELP database
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1992-Apr-25, Jun-24, Jul-29, 1993-Jan-18
 *
 *              This gem is supplied with the Rice CMS Gopher server.
 *              Feel free to use it as an example of building
 *              your own Gopher server smart pipeline stages.
 */
 
Parse Source . . . . . arg0 .
argo = arg0 || ':'
Parse Arg args
Say argo args
 
/*  accept a command line;  remember options  */
Parse Upper Arg item '(' opts ')' .
 
/*  the "item" may have leading "path" parts,  which we just ignore   */
Do While Index(item,'/') > 0; Parse Var item . '/' item; End
 
/*  make it right  */
If Words(item) = 0 Then item = "TASK HELP"
If Words(item) = 1 Then topic = "CMS"
                   Else Parse Var item topic item .
 
/*  is it a task? menu? or leaf item?  */
If item = "TASK" Then Do; item = topic; topic = "TASK"; End
If item = "MENU" Then Do; item = topic; topic = "MENU"; End
 
/*  call the right pipeline stages  */
Select  /*  topic  */
 
    When topic = "TASKTEXT" Then Call HELPTEXT
    When topic = "MENUTEXT" Then Call HELPTEXT
 
    When topic = "TASK"     Then Call HELPTASK
 
    When topic = "MENU"     Then CALL HELPMENU
 
    Otherwise                    CALL HELPITEM
 
    End  /*  Select  topic  */
 
Exit rc
 
 
 
/* ------------------------------------------------------------ HELPITEM
 *  Neither a TASK nor a MENU node;  this is a leaf.
 */
HELPITEM:
 
'CALLPIPE COMMAND HELP' topic item '(NOSCREEN' opts '| *:'
 
Return
 
 
 
/* ------------------------------------------------------------ HELPTEXT
 *  This section is a left-over from the pre-Panda version.
 *  It is still called if you invoke the older HELPTASK or HELPMENU.
 */
HELPTEXT:
 
/*  it would be way-cool if we could present the preliminary text     *
 *  ("user instructions",  or whatever you want to call it)           *
 *  as a plain-text item from the menu we're creating here.           */
 
If topic = "MENUTEXT" Then 'ADDPIPE <' item 'HELPMENU * | *.INPUT:'
                      Else 'ADDPIPE <' item 'HELPTASK * | *.INPUT:'
If rc ^= 0 Then Return
 
/* read and replay displayed text or "user instructions" from task */
Do Forever
 
    'PEEKTO LINE'
    If rc ^= 0 Then Leave
 
    If Strip(line) = "" & Strip(prev) = "" Then Leave
 
    If Left(line,1) ^= '.' Then Do
        /* remove any HELP control sequences */
        p = Index(line,'4A'x)
        Do While p > 0
            line = Left(line,p-1) || Substr(line,p+2)
            p = Index(line,'4A'x)
            End
        /* and send this line of text down the pipe */
        'OUTPUT' line
        If rc ^= 0 Then Leave
        End
 
    prev = line
    'READTO'
    If rc ^= 0 Then Leave
 
    End  /*  Do  Forever  */
 
Return
 
 
 
/* ------------------------------------------------------------ HELPTASK
 *  Selected item is a TASK.   Presume we have GOPSRVMB following.
 */
HELPTASK:
 
'ADDPIPE <' item 'HELPTASK * | *.INPUT:'
If rc ^= 0 Then Return
 
/* first show the displayed text or user instructions as "info" */
Do Forever
 
    'PEEKTO LINE'
    If rc ^= 0 Then Leave
 
    If Strip(line) = "" & Strip(prev) = "" Then Leave
    If Left(line,1) ^= '.' Then 'OUTPUT' 'i' || line
    If rc ^= 0 Then Leave
    prev = line
 
    'READTO'
    If rc ^= 0 Then Leave
 
    End  /*  Do  Forever  */
 
/* now interpret the task lines and make a menu */
Do Forever
 
    'PEEKTO LINE'
    If rc ^= 0 Then Leave
 
    If Left(line,1) ^= '.' & Strip(line) ^= "" Then Do
        /* ignoring blank lines and control lines */
        Parse Var line 1 path 25 title
 
        /* remove HELP control sequences from titles */
        p = Index(title,'4A'x)
        Do While p > 0
            title = Left(title,p-1) || Substr(title,p+2)
            p = Index(title,'4A'x)
            End
 
        type = "0"
        Parse Upper Var path topic item . '(' . ')' .
        If item = "TASK" Then Do; item = topic; topic = "TASK"; End
        If item = "MENU" Then Do; item = topic; topic = "MENU"; End
        If topic = "TASK" | topic = "MENU" Then type = "1"
        'OUTPUT' type || title || '05'x || type || topic item
/*      'OUTPUT' type || title || '05'x || type || path               */
        If rc ^= 0 Then Leave
        End  /*  If  ..  Do  */
 
    'READTO'
    If rc ^= 0 Then Leave
 
    End  /*  Do  Forever  */
 
Return
 
 
 
/* ------------------------------------------------------------ HELPMENU
 *  Selected item is a MENU.   Presume we have GOPSRVMB follows.
 */
HELPMENU:
 
'ADDPIPE <' item 'HELPMENU * | *.INPUT:'
If rc ^= 0 Then Return
 
topic = item
 
/* first show the displayed text or user instructions as "info" */
Do Forever
 
    'PEEKTO LINE'
    If rc ^= 0 Then Leave
 
    /* Menu type */
    if left(line,3) = '.mt' then parse var line . topic .
 
    If Strip(line) = "" & Strip(prev) = "" Then Leave
    If Left(line,1) ^= '.' Then 'OUTPUT' 'i' || line
    If rc ^= 0 Then Leave
    prev = line
 
    'READTO'
    If rc ^= 0 Then Leave
 
    End  /*  Do  While  */
 
Do Forever
 
    'PEEKTO LINE'
    If rc ^= 0 Then Leave
 
    /* Menu type */
    if left(line,3) = '.mt' then parse var line . topic .
 
    If Left(line,1) ^= '.' & Strip(line) ^= "" Then Do
        Parse Var line item .
        key = Left(item,1)
        Select  /*  key  */
            When key = '*' Then
                'OUTPUT' "1" || line || '05'x ||  ,
                    "1" || "MENU" Substr(item,2)
            When key = ':' Then
                'OUTPUT' "1" || line || '05'x || ,
                    "1" || "TASK" Substr(item,2)
            Otherwise
                'OUTPUT' "0" || line || '05'x || ,
                    "0" || topic item
            End  /*  Select  key  */
        If rc ^= 0 Then Leave
        End  /*  If  ..  Do  */
 
    'READTO'
    If rc ^= 0 Then Leave
 
    End  /*  Do  While  */
 
Return
 
 
 
/*  The following two routines are useful if you serve    *
 *  clients that can't handle the Panda "info" type       */
 
 
 
/* ------------------------------------------------------------ HELPTASK
 */
HELPTASK:
 
'ADDPIPE DISK' item 'HELPTASK * | *.INPUT:'
 
/* first consume the displayed text or "user instructions" */
'PEEKTO LINE'
Do While rc = 0
    If Strip(line) = "" & Strip(prev) = "" Then Leave
    prev = line
    'READTO'
    'PEEKTO LINE'
    End  /*  Do  While  */
 
'OUTPUT' "0" || item "task heading text" || '05'x || ,
         "0" || "TASKTEXT" item
 
/* now interpret the task lines and make a menu */
'PEEKTO LINE'
Do While rc = 0
    If Left(line,1) ^= '.' & Strip(line) ^= "" Then Do
        /* ignoring blank lines and control lines */
        Parse Var line 1 path 25 title
 
        /* remove HELP control sequences from titles */
        p = Index(title,'4A'x)
        Do While p > 0
            title = Left(title,p-1) || Substr(title,p+2)
            p = Index(title,'4A'x)
            End
 
        type = "0"
        Parse Upper Var path topic item .
        If item = "TASK" Then Do; item = topic; topic = "TASK"; End
        If item = "MENU" Then Do; item = topic; topic = "MENU"; End
        If topic = "TASK" | topic = "MENU" Then type = "1"
        'OUTPUT' type || title || '05'x || type || topic item
/*      'OUTPUT' type || title || '05'x || type || path               */
        End  /*  If  ..  Do  */
 
    'READTO'
    'PEEKTO LINE'
    End  /*  Do  While  */
 
Return
 
 
 
/* ------------------------------------------------------------ HELPMENU
 */
HELPMENU:
 
'ADDPIPE DISK' item 'HELPMENU * | *.INPUT:'
 
topic = item
 
/* first consume the displayed text or "user instructions" */
'PEEKTO LINE'
Do While rc = 0
    If Strip(line) = "" & Strip(prev) = "" Then Leave
    prev = line
    'READTO'
    'PEEKTO LINE'
    End  /*  Do  While  */
 
'OUTPUT' "0" || item "menu heading text" || '05'x || ,
         "0" || "MENUTEXT" item
 
'PEEKTO LINE'
Do While rc = 0
    If Left(line,1) ^= '.' & Strip(line) ^= "" Then Do
        Parse Var line item .
        key = Left(item,1)
        Select  /*  key  */
            When key = '*' Then
                'OUTPUT' "1" || line || '05'x ||  ,
                    "1" || "MENU" Substr(item,2)
            When key = ':' Then
                'OUTPUT' "1" || line || '05'x || ,
                    "1" || "TASK" Substr(item,2)
            Otherwise
                'OUTPUT' "0" || line || '05'x || ,
                    "0" || topic item
            End  /*  Select  key  */
        End  /*  If  ..  Do  */
    'READTO'
    'PEEKTO LINE'
    End  /*  Do  While  */
 
Return
 
