/*
 *        Name: GOPSRVGL REXX
 *              read and process a GOPHER (link) file for GOPHERD
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1993-Jan-15
 */
 
/*
 *      Copyright 1993 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
Address "COMMAND" 'GLOBALV SELECT GOPHERD GET HOST PORT'
localhost = host;   localport = port
host = "";  port = "";  path = "";  name = "";  type = ""
 
Do Forever
 
    'PEEKTO RECORD'
    If rc ^= 0 Then Leave
 
    If Left(record,1) = '*' Then Call WRITELINK
    If Left(record,1) = '#' Then Call WRITELINK
    If rc ^= 0 Then Leave
 
    Parse Var record var '=' val
    Upper var; var = Strip(var)
    Select  /*  var  */
        When var = "TYPE" Then type = Strip(val)
        When var = "NAME" Then name = val
        When var = "PATH" Then path = val
        When var = "HOST" Then host = Strip(val)
        When var = "PORT" Then port = Strip(val)
        Otherwise nop   /*  ignore invalid lines  */
        End  /*  Select  var  */
 
    'READTO'
    If rc ^= 0 Then Leave
 
    End  /*  Do  Forever  */
 
If rc = 12 Then Call WRITELINK
 
Exit rc * (rc ^= 12)
 
 
 
/* ----------------------------------------------------------- WRITELINK
 *  Looks like a break.  Iff we have everthing,
 *  then write this link and reset the variables to empty strings.
 */
WRITELINK:
If  name = "" | type = "" Then  Return
If  host = ""   Then host = localhost
If  host = "+"  Then host = localhost
If  type = "FILE"       Then type = '0'
If  type = "DIRECTORY"  Then type = '1'
If  port = "" Then
Select  /*  type  */
    When  type = '2'  Then port = '105'
    When  type = '8'  Then port = '23'
    When  type = 'T'  Then port = '23'
    Otherwise port = '70'
    End  /*  Select  type  */
'OUTPUT' type || name || '05'x || path || '05'x ,
              || host || '05'x || port
host = "";  port = "";  path = "";  name = "";  type = ""
Return
 
