/*
 *        Name: GOPSRVMB REXX
 *              CMS Gopher Server menu builder pipeline stage
 *              Based on the older GOPHERDM REXX stage from 2.3.
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1993-Jan-15
 */
 
/*
 *      Copyright 1993 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
uc = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
lc = "abcdefghijklmnopqrstuvwxyz"
 
/*  sync with input  */
'PEEKTO'
If rc ^= 0 Then Exit rc * (rc ^= 12)
 
/*  experience shows that sometimes GLOBALV SELECT        *
 *  doesn't work unless you explicitly sync with PEEKTO   */
Address "COMMAND" 'GLOBALV SELECT GOPHERD GET HOST PORT PATH MENU'
localhost = host
localport = port
localpath = path
Say "Global PATH =" path
 
Do Forever
 
    'PEEKTO RECORD'
    If rc ^= 0 Then Leave
 
    key = Left(record,1)
    Select  /*  key  */
        When key = "*" Then nop
        When Strip(record) = "" Then nop
        When key = " " Then Call FILELIST
        Otherwise           Call PREFAB
        End  /*  Select  key  */
    If rc ^= 0 Then Leave
 
    'READTO'
    If rc ^= 0 Then Leave
 
    End  /*  Do  For  */
 
Exit rc * (rc ^= 12)
 
 
 
/* ------------------------------------------------------------ FILELIST
 *  We're apparently reading a plain FILELIST or LISTFILE output.
 */
FILELIST:
 
q1 = Index(record,"'")
q2 = Index(record,'"')
Select
    When  q1 = 0  & q2 = 0  Then
        Parse Var record fn ft fm fp '05'x name '05'x type '05'x .
    When  q1 = 0  Then
        Parse Var record fn ft fm fp '"'name'"' type .
    When  q2 = 0  Then
        Parse Var record fn ft fm fp "'"name"'" type .
    When  q1 > q2 Then
        Parse Var record fn ft fm fp '"'name'"' type .
    When  q2 > 0  Then
        Parse Var record fn ft fm fp "'"name"'" type .
    End  /*  Select  */
 
If Strip(fn) = "" Then Return
If ft = "" Then ft = "*"
If fm = "" Then fm = "*"
If ft = "GOPHER" | ft = "GOPLINK" Then Do
    /*  read gopher link information  */
    'CALLPIPE <' fn ft fm '| GOPSRVGL | *:'
    Return
    End
 
/*  this is for Yossie:  hide filemode zero  */
If Length(fm) > 1 Then If Substr(fm,2,1) = '0' Then Return
 
fp = Strip(fp)
If fp = "" Then Do
    If  ft = "FILELIST" | ft = '*'  Then fp = Translate(fn,lc,uc)
    Else  fp = Translate(fn||'.'||ft,lc,uc)
    End  /*  If  ..  Do  */
 
If name = "" Then name = fp     /*  default name is relative path  */
fp = Translate(fp,"%","/")        /*  no slashes in partial path!  */
If type = "" Then type = gtype(ft)
host = localhost
port = localport
path = type || localpath || '/' || fp
 
/* read overrides from the NAMES file, if any */
If menu ^= "" Then Call GOVER
 
'OUTPUT' type || name || '05'x || ,
      /* type */ path || '05'x || ,
                 host || '05'x || port
 
Return
 
 
 
/* -------------------------------------------------------------- PREFAB
 *  Preceeding stage has supplied some of the parameters.  (thank you)
 */
PREFAB:
 
Parse Var record name '05'x path '05'x host '05'x port '05'x rest
Parse Var path 1 type 2 path
path = type || localpath || '/' || path
If host = "" Then host = localhost
If port = "" Then port = localport
'OUTPUT' name || '05'x || path || '05'x || ,
         host || '05'x || port || '05'x || rest
Return
 
 
 
/* --------------------------------------------------------------- GOVER
 *  Read the specified NAMES file for menu data overrides, if any.
 */
GOVER:
 
Address "COMMAND" 'STATE' menu 'NAMES *'
If rc ^= 0 Then Return
 
'CALLPIPE COMMAND NAMEFIND :NICK' fp ,
        ':TYPE :NAME :PATH :HOST :PORT (FILE' menu ,
        '| VAR _TYPE | DROP | VAR _NAME | DROP | VAR _PATH | DROP' ,
        '| VAR _HOST | DROP | VAR _PORT'
If rc ^= 0 Then
'CALLPIPE COMMAND NAMEFIND :FN' fn ':FT' ft ,
        ':TYPE :NAME :PATH :HOST :PORT (FILE' menu ,
        '| VAR _TYPE | DROP | VAR _NAME | DROP | VAR _PATH | DROP' ,
        '| VAR _HOST | DROP | VAR _PORT'
If rc ^= 0 & (ft = "FILELIST" | ft = '*') = 0 Then
'CALLPIPE COMMAND NAMEFIND :NICK .' ,
        ':TYPE :NAME :PATH :HOST :PORT (FILE' fn ,
        '| VAR _TYPE | DROP | VAR _NAME | DROP | VAR _PATH | DROP' ,
        '| VAR _HOST | DROP | VAR _PORT'
If rc ^= 0 Then Return
 
/*      defaults for  type, name, path, host, port    *
 *      are supplied by the calling routine           */
 
If _host ^= "" Then host = _host
If _port ^= "" Then port = _port
If _path ^= "" Then path = _path
If _name ^= "" Then name = _name
If _type ^= "" Then type = _type
 
Select
    When _host ^= "" & _port = "" Then port = 70
    When _host = "" & _port ^= "" Then host = localhost
    Otherwise nop
    End  /*  When  Select  */
 
If _host ^= "" | _port ^= "" Then Do
    path = _path
    type = _type
    If type = "" Then type = "1"
    End  /*  If  ..  Do  */
Else If _type ^= "" & _path = "" Then
    path = _type || localpath || '/' || fp
 
Return
 
 
 
/* --------------------------------------------------------------- GTYPE
 * Returns the default Gopher type character for CMS filetype specified.
 */
GTYPE:    Procedure
Parse Arg ft
Select  /*  ft  */
    When ft = "*"        Then Return '1'
    When ft = "-"        Then Return '1'
    When ft = ""         Then Return '1'
    When ft = "FILELIST" Then Return '1'
    When ft = "GOPHER"   Then Return '1'
/*  When ft = "CSO"      Then Return '2'  */
/*  When ft = ?          Then Return '3'  */
    When ft = "HQX"      Then Return '4'    /*  type 4 for Mac  */
    When ft = "ZIP"      Then Return '5'    /*  type 5 for DOS  */
    When ft = "UUE"      Then Return '6'    /*  type 6 for UUEncoded  */
/*  When ft = "SEARCH"   Then Return '7'  */
/*  When ft = "TELNET"   Then Return '8'  */
    When ft = "TXT"      Then Return '0'    /*  plain text  */
    When ft = "TEXT"     Then Return '9'    /*  deck; not plain text  */
    When ft = "TXTLIB"   Then Return '9'
    When Left(ft,3) = "TXT" Then Return '9'
    When ft = "CARDDUMP" Then Return '9'
    When ft = "VMARC"    Then Return '9'
    When ft = "TAR"      Then Return '9'
    When ft = "EXE"      Then Return '9'
    When ft = "DVI"      Then Return '9'
    When ft = "TFM"      Then Return '9'
    When ft = "FMT"      Then Return '9'
    When ft = "ADMGDF"   Then Return '9'
    When ft = "ADMSYMBL" Then Return '9'
    When ft = "SASUSER"  Then Return '9'
    When ft = "SAS6USER" Then Return '9'
    When ft = "SND"      Then Return 's'
/*  When ft = "EPS"      Then Return 'p'  */
/*  When ft = "PS"       Then Return 'p'  */
    When ft = "MODULE"   Then Return 'v'
    When ft = "LOADLIB"  Then Return 'v'
    When ft = "XRX"      Then Return 'v'
    When ft = "GIF"      Then Return 'I'
    Otherwise                 Return '0'
    End  /*  Select  ft  */
 
