/*
 *        Name: GOPSRVRP REXX
 *              resolve gopher paths (selector strings) recursively
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1993-Jan-15, 19
 *
 *              This file is part of CMS Gopher.
 */
 
/*
 *      Copyright 1993 Richard M. Troth.   This software was developed
 *      with resources provided by Rice University and is intended
 *      to serve Rice's user community.   Rice has benefitted greatly
 *      from the free distribution of software,  therefore distribution
 *      of unmodified copies of this material is not restricted.
 *      You may change your own copy as needed.   Neither Rice
 *      University nor any of its employees or students shall be held
 *      liable for damages resulting from the use of this software.
 */
 
Parse Source . . arg0 .
Parse Arg nick '/' rest
nick = Strip(nick)
rest = Strip(rest)
 
Do While nick = ""      /*  deal with null parts w/o recursion  */
    If rest = "" Then Do; 'SHORT'; Exit rc; End
    Parse Var rest nick '/' rest
    End  /*  Do  While  */
/*
If nick = "" Then Do    **  deal with null parts by recursion  **
    If rest = "" Then 'SHORT'
                 Else 'CALLPIPE *: |' arg0 rest '| *:'
    Exit rc
    End  **  If  ..  Do  **
 */
 
/*  look for the shortcut on pure LISTFILE ouptut  */
'PEEKTO RECORD'
If rc ^= 0 Then Exit rc * (rc ^= 12)
If Strip(record) = "" Then Signal SHORTCUT
 
/*  part = nick;  Upper part  */
Parse Upper Var nick part
 
Do Forever
 
    'READTO RECORD'
    If rc ^= 0 Then Leave
    If Left(record,1) = '*' Then Iterate
    If Left(record,1) ^= ' ' Then Leave         /*  short cut  */
 
    Parse Upper Var record fn ft fm fp '"' . "'" . '05'x .
    If Strip(fn) = "" Then Iterate
 
    If  fp = "" Then  Select  /*  ft  */
        When  Index(fn,'*') > 0 Then    fp = fn || '.' || ft
        When  ft = ""   | ft = "*"  | ,
              ft = "FILELIST"   Then    fp = fn
        Otherwise                       fp = fn || '.' || ft
        End  /*  Select  ft  */
    If Strip(fp) ^= part Then Iterate
 
Say "GOPSRVRP: matched" fn ft fm fp
    /*  found it!  */
    /*  Parse Arg nick '/' .  */
    Address "COMMAND" 'GLOBALV SELECT GOPHERD PUT NICK'
    If rest = "" Then 'CALLPIPE GOPSRVLS' fn ft fm '| *:'
                 Else 'CALLPIPE GOPSRVLS' fn ft fm '|' arg0 rest '| *:'
    /*  Leave  */  Exit rc
 
    End
 
FALLOUT:
Say "GOPSRVRP: didn't find a match for" nick
/*  fallout;  we didn't find a match in this menu  */
/*  Parse Arg nick  */
nick = nick || '/' || rest
Address "COMMAND" 'GLOBALV SELECT GOPHERD PUT NICK'
'CALLPIPE GOPSRVLS ? ? ? | *:'
 
Exit rc
 
SHORTCUT:
Parse Var nick fn '.' ft '.' .
If fn = "" Then fn = '*'
If ft = "" Then ft = '*'
fm = '*'
Say "GOPSRVRP: shortcut to" fn ft fm
    /*  found it!  */
    /*  Parse Arg nick '/' .  */
    Address "COMMAND" 'GLOBALV SELECT GOPHERD PUT NICK'
    If rest = "" Then 'CALLPIPE GOPSRVLS' fn ft fm '| *:'
                 Else 'CALLPIPE GOPSRVLS' fn ft fm '|' arg0 rest '| *:'
    /*  Leave  */  Exit rc
 
 
