/*
 *        Name: GOPSRVYS REXX
 *              Gopher Server Search Engine utilizing WISHLP
 *              Original by Yossie Silverman <YOSSIE@UCSFVM>
 *
 *       Input: FILELIST formatted list of files with descriptions
 *      Output: FILELIST formatted list of files matching search
 *
 *   To create a search item do the following:
 *
 *     1) Create a standard gopher FILELIST of all files to be
 *        searched.  (Only ' fn ft fm title' will work, fm can
 *        (and should) be *
 *     2) GOPGEN INDEX menu
 *     3) Put the name and title of the searched menu
 *        in the menu you want to access it from (parent)
 *     4) Mark the searched menu as Type 7 either
 *        with a NAMES file or in the parent menu.
 *
 *     Changes:
 * 1993-Aug-20: Changed search string processing so that             RMT
 *              search string is not passed as a paramater.          RMT
 *              Also incorporated Yossie's use of LOOKUP.            RMT
 */
 
'PEEKTO'            /*  sync with input  */
 
Address "COMMAND" 'GLOBALV SELECT GOPHERD GET MENU FM PARM'
'CALLPIPE COMMAND LISTFILE' menu 'GOPINDEX * (NOHEADER' ,
        '| VAR FILESPEC'
If rc ^= 0 Then Exit rc
Parse Var filespec . . fm .
Say "GOPSRVYS: MENU =" menu '-' fm
parm = Translate(parm,' ','05'x)
Say "GOPSRVYS: PARM =" parm
 
/*
   WISHLP will deliver the matching filenames from GOPINDEX;
   then use "lookup" to correlate the filenames with their
   FILELIST entries so that we have the correct descriptive
   name etc.  This was Yossie's nifty idea.
*/
 
'ADDSTREAM INPUT SRCH'
'ADDPIPE (STAGESEP' '05'x || ')' ,
    'COMMAND WISHLP' menu 'GOPINDEX' fm parm ,
        '05'x '*.INPUT.SRCH:'
'CALLPIPE (END !) *.INPUT.0:' ,
    '| SPEC WORD 1 1 WORD 2 10 WORD 3-* 19' ,    /* format for lookup */
    '| A: LOOKUP 1.17 DETAIL' ,     /* pick up their filelist entries */
    '| SPEC 1-* 2 | *:' ,            /* caller wants a blank in col 1 */
    '! *.INPUT.SRCH: | A:'               /* feed lookup's secy stream */
 
Exit rc
 
