/*
 *        Name: MAIL REXX
 *              "mail" the plain-text input stream to someone
 *
 *        Note: this gem should feed SENDMAIL, but as of 1993-Jul-14
 *              SENDMAIL REXX still doesn't exist.
 */
 
'PEEKTO'
If rc ^= 0 Then Exit rc * (rc ^= 12)
 
Parse Source . . arg0 .
Parse Arg dest . '(' opts ')' .
 
Address "COMMAND" 'GETFMADR'
If rc ^= 0 Then Exit rc
Parse Pull . . va .
'CALLPIPE CP DEFINE PUNCH' va
'CALLPIPE CP SPOOL' va 'TO' mailer 'CLASS M FORM QUMAIL'
'CALLPIPE CP SPOOL' va 'NOMSG'
 
'CALLPIPE COMMAND IDENTIFY | XLATE LOWER | VAR IDENTITY'
Parse Var identity userid . hostid . . date time tz day .
Parse Var date mm '/' dd '/' yy
day = Left(day,3)
mon = mon(mm)
 
Address "COMMAND" 'GLOBALV SELECT MAIL GET SUBJECT'
Address "COMMAND" 'GLOBALV SELECT MAIL GET' ,
    'MAIL_OPTION.ORGANIZATION.NAME' ,
        'MAIL_OPTION.LOCAL.DOMAIN'
 
head.0 = 7
head.1 = "Date:" day || ',' dd mon yy time tz
head.2 = "From:" userid || '@' || hostid
head.3 = "Subject:" subject
head.4 = "To:" dest
head.5 = "MIME-Version: 1.0"
head.6 = "Content-Type: text/plain"
head.7 = " "
 
'CALLPIPE STEM HEAD. | SPEC x41 1 1-* NEXT | URO' va
If rc ^= 0 Then Exit rc
 
'CALLPIPE *: | SPEC x41 1 1-* NEXT | URO' va
If rc ^= 0 Then Exit rc
 
'CALLPIPE CP CLOSE' va 'NAME' userid 'MAIL'
'CALLPIPE CP DETACH' va
 
Exit
 
 
 
/* ----------------------------------------------------------------- MON
 */
MON: Procedure
 
Parse Arg mm
If ^Datatype(mm,'N') Then Return mm
 
/*  first try extracting month name from the message repository  */
'CALLPIPE COMMAND XMITMSG 8559 (APPLID DMS' ,
    'FORMAT mm LINE 2 NOHEADER | VAR MONTH'
If rc = 0 Then Return month
 
/*  if that failed, then you're stuck with AMENG equivalents  */
Select  /*  mm  */
    When mm = 1  Then Return "Jan"
    When mm = 2  Then Return "Feb"
    When mm = 3  Then Return "Mar"
    When mm = 4  Then Return "Apr"
    When mm = 5  Then Return "May"
    When mm = 6  Then Return "Jun"
    When mm = 7  Then Return "Jul"
    When mm = 8  Then Return "Aug"
    When mm = 9  Then Return "Sep"
    When mm = 10 Then Return "Oct"
    When mm = 11 Then Return "Nov"
    When mm = 12 Then Return "Dec"
    Otherwise Return mm
    End  /*  Select  mm  */
 
