/*
 *        Name: PIPESOCKET REXX
 *              until the day when there's a truly asynch SOCKET stage
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1993-Feb-23
 */
 
Parse Source . . . . . arg0 .
argo = arg0 || ':'
 
Parse Upper Arg func .
Select  /*  func  */
    When Abbrev("READ",func,1)     Then Signal READ
    When Abbrev("WRITE",func,1)    Then Signal WRITE
    Otherwise Do
        'CALLPIPE COMMAND XMITMSG 3 FUNC (ERRMSG' ,
            'CALLER SOX | CONSOLE'
        Exit 24
        End  /*  Otherwise  Do  */
    End  /*  Select  func  */
 
 
/* ---------------------------------------------------------------- READ
 */
READ:
 
Parse Upper Arg . sock opts
 
'CALLPIPE *: | SPEC 1-* 1 | *:'         /*  allow follow-through  */
 
'OUTPUT'
 
Do Forever
 
    Parse Value Socket("READ", sock, 61440) With rc bc data
    If rc ^= 0 Then Do
        Say argo tcperror()
        Exit rc
        End  /*  If  ..  Do  */
    If bc < 1 Then Leave
 
    'OUTPUT' data
    If rc ^= 0 Then Leave
 
    End  /*  Do  Forever  */
 
Exit rc * (rc ^= 12)
 
 
/* --------------------------------------------------------------- WRITE
 *  Send records from the input stream to the socket as packets.
 */
WRITE:
 
Parse Upper Arg . sock opts
 
Do Forever
 
    'PEEKTO DATA'
    If rc ^= 0 Then Leave
 
    Parse Value Socket("WRITE", sock, data) With rc bc .
    If rc ^= 0 Then Do
        Say argo tcperror()
        Exit rc
        End  /*  If  ..  Do  */
 
    'OUTPUT' data
    'READTO'
 
    End  /*  Do  Forever  */
 
Exit rc * (rc ^= 12)
 
