/*
 *        Name: TCPE2A REXX
 *              CMS Pipelines filter to translate EBCDIC to ASCII
 *              basing translation on VM TCP/IP supplied tables
 *      Author: Rick Troth, Rice University, Information Systems
 *        Date: 1992-Apr-27, 1993-Jan-05
 */
 
Parse Upper Arg table . '(' .
 
If table = "" Then table = "STANDARD"
'CALLPIPE DISK' table 'TCPXLBIN | STEM XLT.'
 
/*  if specified table is unavailable,  fall back to default  */
If xlt.0 < 3 Then Do
    'CALLPIPE *: | E2A | *:'
    Exit rc
    End  /*  If  ..  Do  */
 
/*
 * variables:
 *              xlt.0   should be "3",  meaning three records read
 *              xlt.1   should be a comment
 *              xlt.2   should be our ASCII ---> EBCDIC table
 *              xlt.3   should be our EBCDIC ---> ASCII table
 *              i       is set to the dummy input table
 */
 
    i =      '000102030405060708090A0B0C0D0E0F'x
    i = i || '101112131415161718191A1B1C1D1E1F'x
    i = i || '202122232425262728292A2B2C2D2E2F'x
    i = i || '303132333435363738393A3B3C3D3E3F'x
    i = i || '404142434445464748494A4B4C4D4E4F'x
    i = i || '505152535455565758595A5B5C5D5E5F'x
    i = i || '606162636465666768696A6B6C6D6E6F'x
    i = i || '707172737475767778797A7B7C7D7E7F'x
    i = i || '808182838485868788898A8B8C8D8E8F'x
    i = i || '909192939495969798999A9B9C9D9E9F'x
    i = i || 'A0A1A2A3A4A5A6A7A8A9AAABACADAEAF'x
    i = i || 'B0B1B2B3B4B5B6B7B8B9BABBBCBDBEBF'x
    i = i || 'C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF'x
    i = i || 'D0D1D2D3D4D5D6D7D8D9DADBDCDDDEDF'x
    i = i || 'E0E1E2E3E4E5E6E7E8E9EAEBECEDEEEF'x
    i = i || 'F0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF'x
 
/* ----------------------------------------------------------------- E2A
 * Translate EBCDIC to ASCII.
 */
'READTO LINE'
Do While rc = 0
    'OUTPUT' Translate(line,xlt.3,i)
    'READTO LINE'
    End  /*  Do  While  */
 
Exit
 
