/* conf.h
 *
 * Part of the Internet Gopher program, copyright (C) 1991
 * University of Minnesota Microcomputer Workstation and Networks Center
 *
 * These are the user definable parameters
 */

/*
 * These variables are usually set in the makefile.  If they're not
 * set then the following definitions will be used
 */ 

#ifndef DEFAULT_HOST
#define DEFAULT_HOST     "gopher"
#endif

#ifndef GOPHERHELP
#define GOPHERHELP      "gopher.hlp"
#endif

#ifndef GOPHER_PORT
#define GOPHER_PORT      70
#endif

/*
** Uncomment this out if you want to make a client with a slightly
** different user interface that will work for people with really, really
** stupid terminals (i.e. people using VM/CMS ANET for a vt100 terminal
** emulator (Gross!)
*/

/*#define STUPIDTERM  /**/

/*
 *  Try to automatically determine the type of system we're using
 */

#if !defined(IS_A_SUN) && defined(sun)
#define IS_A_SUN
#endif

#if !defined(IS_A_DEC) && defined(ultrix)
#define IS_A_DEC
#endif

#if !defined(IS_NEXT) && defined(NeXT)
#define IS_NEXT
#endif

#if !defined(IS_BSD) && defined(n16)
#define IS_BSD
#endif

#if !defined(IS_MESS_DOS) && defined(MSDOS)
#define IS_MESS_DOS
#endif

/*
 * Override some defaults for various platforms
 */
#ifdef IS_A_SUN
#define PLAY_COMMAND "/usr/local/bin/play -v 40 -"
#define USE_DIRENT
#endif

#ifdef IS_A_DEC
#define SYSVCURSES
#define USE_DIRENT
#endif

#ifdef IS_A_HPUX
#define SYSVCURSES
#define MAIL_COMMAND "mailx"
#define USE_DIRENT
#endif


#ifdef IS_AUX_BOX
#ifndef IS_AUX20_BOX
#define SYSVCURSES
#endif
#endif

#ifdef IS_A_RS6000
#define SYSVCURSES
#endif

#ifdef IS_BSD
#define tolower
#define NO_VPRINTF
#endif

#ifdef IS_NEXT
#define __STRICT_BSD__
#define NO_VPRINTF
#define PLAY_COMMAND "/usr/local/bin/play -v 40 -"
#endif

#ifdef IS_A_IRIS
#define tolower
#define SYSVCURSES
#define USE_DIRENT
#endif

#ifdef STUPIDTERM
#define PAGER_COMMAND "builtin"
#endif

#ifdef IS_MESS_DOS
/* If  you want to enable copius memory debugging output, uncomment this */
/* #define MEMACCT */
#define SYSVCURSES
#define NEAR __near
#ifdef LWP
#define TELNET_COMMAND  "tnvt220.exe"
#define MAIL_COMMAND    ""
#define TN3270_COMMAND ""
#else
#ifdef PCNFS
#define TELNET_COMMAND  "telnet.exe"
#define MAIL_COMMAND    ""
#define TN3270_COMMAND ""
#else
#ifdef PCTCP
#define PCTCP_DIR "C:\\PCTCP"
#define TELNET_COMMAND "tn.exe"
#define TN3270_COMMAND "tn.exe"
#define MAIL_COMMAND "mail.exe"
#endif
#endif
#endif
#define PAGER_COMMAND "builtin"
#define PLAY_COMMAND ""
#define GIF_COMMAND ""
#endif

/*
 * Now set the parameters, only if not set above... 
 */
#ifndef PAGER_COMMAND
#define PAGER_COMMAND "more -d"
#endif

#ifndef MAIL_COMMAND
#define MAIL_COMMAND "mail"
#endif

#ifndef TELNET_COMMAND
#define TELNET_COMMAND "telnet"
#endif

#ifndef TN3270_COMMAND
#define TN3270_COMMAND "tn3270"
#endif

#ifndef PRINTER_COMMAND
#define PRINTER_COMMAND "lpr"
#endif

#ifndef PLAY_COMMAND
#define PLAY_COMMAND "/bin/false"
#endif

#ifndef MIME_COMMAND
#define MIME_COMMAND "metamail"
#endif

#ifndef NEAR
#define NEAR
#endif

/*
 * Initial number of gopher items in a GopherDirObj directory, 
 */


#define MAXGOPHERS 512
#define INITIAL_GOPHERS 64

/*
 * Don't mess with this...
 */

#define GOPHER_CLIENT

