#include <stddef.h>
#include <stdio.h>
#include <malloc.h>
#include "gopher.h"
#include "dosmem.h"

size_t memInUse = 0;
#ifdef MEMACCT
static FILE *mp = NULL;
static void
prepM()
{
	if (mp == NULL)
		if((mp = fopen("memacct.txt", "w")) == NULL)
                    exit(-1);
}

static void
flushM()
{
	fflush(mp);
}
#endif /* MEMACCT */
void *s_malloc(size)
     size_t size;
{
     register void *ptr = NULL;

     ptr = (void *) calloc(1, size);
     if (ptr == NULL)
        err_sys("s_malloc");

     memInUse += size;
#ifdef MEMACCT
     prepM();
     fprintf(mp, "\nalloc'd %u bytes, %lu used", size, memInUse);
     flushM();
#endif 
     return(ptr);
}

void *s_realloc(ptr, size)
	void *ptr;
	size_t size;
{
    register void *p = NULL;
    register size_t i;

    if(ptr == NULL)
	return(s_malloc(size));
    i = sizeof(ptr);
    p = (void *)realloc(ptr, size);
    memInUse += size - i;

#ifdef MEMACCT
    prepM();
    fprintf(mp, "\nrealloc'd %d bytes from %d, %lu in use", size - i, i, memInUse);
    flushM();
#endif
    return(p);
}
void s_free(ptr)
     void *ptr;
{
    register size_t i;

    if(ptr != NULL) {
/* 
 * _msize() supposedly returns the size of a block.  MSC only though.
 */
       i = sizeof(ptr);
#ifdef MEMACCT
       if(i > memInUse) {
	prepM();
	fprintf(mp, "WARNING!! Freeing %u bytes, only %u in use!\n", i, memInUse);
	flushM();
       }
#endif
       free(ptr);
       memInUse -= i;
#ifdef MEMACCT
       prepM();
       fprintf(mp, "\nfreed %d bytes, %lu in use", i, memInUse);
       flushM();
#endif
    }
}

