/* globals.h
 *
 * Part of the Internet Gopher program, copyright (C) 1991
 * University of Minnesota Microcomputer Workstation and Networks Center
 *
 * In this file you will find all of the global variables and 
 * global defines.
 */


#define BOOLEAN      int                /* for TRUE/FALSE variables */
#define ROOT_LEVEL   0                  /* and be replaced with linked lists*/
#define ROOT_DIRECTORY "Root Directory" /* label for top level */

#define MAXRESP      9                  /* Max size of a response list*/
                                        /* Used in ourutil.c */

/*
 * These are some funky defines that assures that global variables are
 * declared only once.  (when globals.c includes this file with EXTERN
 * defined.
 */

#ifndef EXTERN
#define EXTERN extern
#define INIT(x)
#else
#define EXTERN
#define INIT(x) =x
#endif


/*** Global variables ***/

EXTERN char    *np INIT(NULL);
EXTERN WINDOW  *MainWindow; 
EXTERN int     iMenuLines;
EXTERN char    sGClearscreen[HALFLINE];     /* Termcaps screen-clear buffer */
EXTERN char    sGAudibleBell[8];            /* Same, for bell */
EXTERN char    sGCursorDown[10];
EXTERN char    sGCursorUp[10];
EXTERN char    sGHighlighton[20];
EXTERN char    sGHighlightoff[20];

EXTERN char    PrinterCommand[WHOLELINE]; /*used for configuration options */
EXTERN char    PagerCommand[WHOLELINE];   /*used for configuration options */
EXTERN char    TelnetCommand[WHOLELINE];  /*used for configuration options */
EXTERN char    TN3270Command[WHOLELINE];  /*used for configuration options */
EXTERN char    MailCommand[WHOLELINE];
EXTERN char    PlayCommand[WHOLELINE];
EXTERN char    EditorCommand[WHOLELINE];
EXTERN char    GifCommand[WHOLELINE];
EXTERN char    MIMECommand[WHOLELINE];
EXTERN BOOLEAN ChangedDefs INIT(FALSE);

EXTERN char    tmpDirPath[_MAX_PATH];
EXTERN char    SavedTitle[WHOLELINE];
EXTERN char    *Searchstring INIT(NULL);
EXTERN int     iLevel INIT(0);
EXTERN BOOLEAN SecureMode INIT(FALSE);
EXTERN BOOLEAN DEBUG INIT(FALSE);
/* EXTERN BOOLEAN DEBUG INIT(TRUE); */

#define OD_MAX 30
EXTERN GopherDirObj *CurrentDir INIT(NULL);
EXTERN GopherDirObj *GDBookmarks INIT(NULL);
EXTERN GopherDirObj *OldDirs[OD_MAX];  /** Should be a stack... **/

EXTERN char    USERCAP[WHOLELINE];    /* The validated user capability */
EXTERN int     SOUNDCHILD INIT(0);     /* The pid of the sound player child. */
#include "version.h"


/*** Externals ***/

#ifndef IS_MESS_DOS
/* MSC nicely defines these */
extern char **environ;                  /* User environment array */
extern char *sys_errlist[];
#else
EXTERN int debugStatus INIT(0);
EXTERN char InstallPath[_MAX_PATH];
#endif /* IS_MESS_DOS */

/*** DEFINES ***/

#define MAXLINE 512

/*** Prototypes and forward declarations ***/

void init_curses();                     /* lives in manager.c */

/*** Ourutils.c ***/
void display_file(char *Filename, char *Realname);
void ZapCRLF(char *buffer);
int  outchar(char c);        
void exit_curses();
char Mygetstr(char *);
void CursesErrorMsg( char* );
void GetOneOption(char*, char* );
GopherStruct *cruise_dirs(GopherStruct*);

int  NEAR process_request(GopherStruct* ZeGopher);
int  NEAR Load_Dir(GopherStruct *ZeGopher);
int  NEAR Load_Index(GopherStruct *ZeGopher);
int  NEAR Load_Index_or_Dir(GopherStruct *, char *);
void GetOneOption(char *, char *);
void check_sock(int, char*);

char *strcasestr(char *, char *);
