/*
 * Utilities to read and write the .gopherrc file 
 */

#include "gopher.h"
#include <stdio.h>
#include <fcntl.h>
#ifndef IS_MESS_DOS
#include <pwd.h>
#endif

FILE *
rcopen(flags) 
  char * flags;
{
     char rcfilename[_MAX_PATH];
     FILE * rcfile;
#ifndef IS_MESS_DOS
     struct passwd *pwdentry;

     pwdentry = getpwuid(geteuid());

     if (pwdentry == NULL)
	  return;

#endif
     /** First, let's find out if there is a bookmark file **/
#ifdef IS_MESS_DOS
     if (getenv("HOME") == NULL)
	strcpy(rcfilename, InstallPath);
     else {
	strcpy(rcfilename, getenv("HOME"));
	strcat(rcfilename, "\\");
     }
     strcat(rcfilename, "_gopher.rc");
#else
     strcpy(rcfilename,pwdentry->pw_dir);   /* Home directory */
     strcat(rcfilename,"/.gopherrc");
#endif
     rcfile = fopen(rcfilename, flags);

     return(rcfile);
}     

void
read_rc()
{
     FILE * rcfile;
     char rcfilename[512];
     char inputline[512];
#ifndef IS_MESS_DOS
     struct passwd *pwdentry;

     pwdentry = getpwuid(geteuid());

     if (pwdentry == NULL)
	  return;
#endif
     rcfile = rcopen("r");

     if (rcfile  == NULL)
	  return;    /*** No such file ***/

     while (fgets(inputline, sizeof(inputline),rcfile) != NULL) {

	  if (*inputline == '#')
	       continue;

	  ZapCRLF(inputline);
	  if (strncasecmp(inputline, "bookmarks:", 9)==0) {
	      
	       if (GDBookmarks == NULL)
		    GDBookmarks = GDnew(OD_MAX);
	       
	       GDfromLink(GDBookmarks, rcfile, "localhost", 70);
	       
	  }
#ifndef IS_MESS_DOS /* No printing */
	  else if (strncasecmp(inputline, "Printercmd: ", 12) == 0) {
	       strcpy(PrinterCommand, inputline + 12);
	  }
          else
#endif /* IS_MESS_DOS */
	  else     if (strncasecmp(inputline, "Telnetcmd: ", 11) == 0) {
	       strcpy(TelnetCommand, inputline + 11);
	  }
	  else if (strncasecmp(inputline, "TN3270cmd: ", 11) == 0) {
	       strcpy(TN3270Command, inputline + 11);
	  }
	  else if (strncasecmp(inputline, "Mailcmd: ", 9) == 0) {
	       strcpy(MailCommand, inputline + 9);
	  }
	  else if (strncasecmp(inputline, "Playcmd: ", 9) == 0) {
	       strcpy(PlayCommand, inputline + 9);
	  }
	  else if (strncasecmp(inputline, "MIMEcmd: ", 9) == 0) {
	       strcpy(MIMECommand, inputline + 9);
	  }
	  else if (strncasecmp(inputline, "PAGERcmd: ", 10) == 0) {
	       strcpy(PagerCommand, inputline + 10);
	  }
#ifdef IS_MESS_DOS
          else if (strncasecmp(inputline, "GIFcmd: ", 8) == 0) {
		strcpy(GifCommand, inputline + 8);
          }
          else if (strncasecmp(inputline, "TMPdir: ", 8) == 0) {
		strcpy(tmpDirPath, inputline + 8);
          }
#endif /* IS_MESS_DOS */
     }

     fclose(rcfile);
}

#ifndef IS_MESS_DOS /* I've done this elsewhere */
void
set_defs()
{
     STRset(MailCommand, MAIL_COMMAND);
     STRset(PrinterCommand, PRINTER_COMMAND);
     STRset(TelnetCommand, TELNET_COMMAND);
     STRset(PlayCommand, PLAY_COMMAND);
     STRset(TN3270Command, TN3270_COMMAND);
     STRset(MIMECommand, MIME_COMMAND);
}     


void
read_env()
{
     /** Get the pager command **/
     
     if (getenv("PAGER") == NULL)
	  STRset(PagerCommand, PAGER_COMMAND);
     else
	  STRset(PagerCommand, getenv("PAGER"));

     if (getenv("EDITOR") == NULL)
	  STRset(EditorCommand, "vi ");
     else
	  STRset(EditorCommand, getenv("EDITOR"));
     
     if (getenv("GOPHER_MAIL") != NULL)
           STRset(MailCommand, getenv("GOPHER_MAIL"));

      if (getenv("GOPHER_PRINTER") != NULL)
           STRset(PrinterCommand, getenv("GOPHER_PRINTER"));

     if (getenv("GOPHER_TELNET") != NULL)
	  STRset(TelnetCommand, getenv("GOPHER_TELNET"));

     if (getenv("GOPHER_PLAY") != NULL)
	  STRset(PlayCommand, getenv("GOPHER_PLAY"));

     if (getenv("GOPHER_TN3270") != NULL)
	  STRset(TN3270Command, getenv("GOPHER_TN3270"));

     if (getenv("GOPHER_MIME") != NULL)
	  STRset(MIMECommand, getenv("GOPHER_MIME"));
}
#endif /* IS_MESS_DOS */

void
write_rc()
{
     FILE *rcfile;
     char rcfilename[512];
     char oldrcfilename[512];
     char inputline[512];
#ifndef IS_MESS_DOS
     struct passwd *pwdentry;

     pwdentry = getpwuid(geteuid());

     if (pwdentry == NULL)
	  return;
#endif /* No passwd in DOS */
     if (SecureMode)
	  return;

     /** First, let's find out if there is a rc file **/
#ifdef IS_MESS_DOS
     if (getenv("HOME") == NULL)
	strcpy(rcfilename, InstallPath);
     else {
	strcpy(rcfilename, getenv("HOME"));
	if (rcfilename[strlen(rcfilename) - 1] != '\\')
	     strcat(rcfilename, "\\");
     }

     strcat(rcfilename, "_gopher.rc");
#else
     strcpy(rcfilename,pwdentry->pw_dir);   /* Home directory */
     strcat(rcfilename,"/.gopherrc");
#endif
#ifdef IS_MESS_DOS
     if (getenv("HOME") == NULL)
	strcpy(oldrcfilename, InstallPath);
     else {
	strcpy(oldrcfilename, getenv("HOME"));
	strcat(oldrcfilename, "\\");
     }

     strcat(oldrcfilename, "_gopher.rc~");
#else
     strcpy(oldrcfilename,pwdentry->pw_dir); 
     strcat(oldrcfilename,"/.gopherrc~");
#endif

     rcfile = fopen(rcfilename, "r");

     if (rcfile != NULL) {
	  fclose(rcfile);
	  remove(oldrcfilename);  /* Can't overwrite in DOS, OK if not there */
	  if (rename(rcfilename, oldrcfilename)<0) {
	       CursesErrorMsg("Aborting gopher configuration save!!");
	       return;
	  }
     }

     rcfile = fopen(rcfilename, "w");

     if (rcfile == NULL) {
	  CursesErrorMsg("Can't write gopher configuration file!!");
	  return;    
     }

     fputs("Telnetcmd: ",rcfile);
     fputs(TelnetCommand,rcfile);
     fputs("\nTN3270cmd: ",rcfile);
     fputs(TN3270Command,rcfile);
     fputs("\nMailcmd: ",rcfile);
     fputs(MailCommand,rcfile);
     fputs("\nPlaycmd: ",rcfile);
     fputs(PlayCommand, rcfile);
     fputs("\nMIMEcmd: ",rcfile);
     fputs(MIMECommand,rcfile);
     fputs("\nPAGERcmd: ", rcfile);
     fputs(PagerCommand, rcfile);
#ifdef IS_MESS_DOS /* DOS has gif but no printing */
     fputs("\nGIFcmd: ",rcfile);
     fputs(GifCommand,rcfile);
     fputs("\nTMPdir: ",rcfile);
     fputs(tmpDirPath,rcfile);
#else
     fputs("\nPrintercmd: ",rcfile);
     fputs(PrinterCommand,rcfile);
#endif /* IS_MESS_DOS */
     
     if (GDBookmarks != NULL) {
	  fputs("\nbookmarks:\n",rcfile);
	  GDtoLink(GDBookmarks, rcfile);
     }
     fclose(rcfile);
}

