#include "STRstrin.h"

#define A_FILE      '0'      /* Types of objects */
#define A_DIRECTORY '1'
#define A_CSO       '2'
#define A_ERROR     '3'
#define A_MACHEX    '4'
#define A_PCHEX     '5'
#define A_INDEX     '7'
#define A_TELNET    '8'
#define A_TN3270    'T'
#define A_TARORZ    '9'
#define A_SOUND     's'
#define A_EVENT     'e'
#define A_CALENDAR  'c'
#define A_IMAGE     'I'
#define A_MIME	    'M'
#ifdef IS_MESS_DOS
#define A_GIF       'g'
#endif
#define A_EOI	    '.'


/** Our Gopher Object Type **/

struct g_struct
{
     char    sFileType;     /* The type of object (A_FILE, A_CSO, etc)*/
     String  *Title;        /* User displayable title */
     String  *Selstr;       /* Selector string on host... */
     String  *Host;         /* Internet name of host                  */
     int     iPort;         /* Port number on host                    */
     int     iItemnum;      /* The number of the item in the directory*/
};



typedef struct g_struct GopherStruct;
typedef struct g_struct GopherObj;

#define GSgetType(a) ((a)->sFileType)
#define GSsetType(a,b) (a)->sFileType=(b)

#define GSgetTitle(a) ((STRget((a)->Title)))
#define GSsetTitle(a,b) ((STRset((a)->Title, b)))

#define GSgetPath(a) ((STRget((a)->Selstr)))
#define GSsetPath(a,b) ((STRset((a)->Selstr, b)))

#define GSgetHost(a) ((STRget((a)->Host)))
#define GSsetHost(a,b) ((STRset((a)->Host, b)))

#define GSgetPort(a) ((a)->iPort)
#define GSsetPort(a,b) (a)->iPort=(b)

#define GSgetNum(a) ((a)->iItemnum)
#define GSsetNum(a,b) (a)->iItemnum=(b)


/*** Real live functions defined in gopherstruct.c ***/

GopherObj *GSnew();
void GSdestroy(GopherObj *);
void NEAR GSinit(GopherObj *);
void NEAR GStoNet(GopherObj *, int);
void NEAR GStoLink(GopherObj *, FILE *);
int  NEAR GSfromNet(GopherObj *, int);
int  NEAR GSfromLink(GopherObj *, FILE *, char *, int);

/****************************************************************
** A Gopher directory structure...
*****************************************************************/

struct g_dir_struct {
     GopherStruct **Gophers;
     
     int Top;
     int maxsize;
};

typedef struct g_dir_struct GopherDirObj;
typedef struct g_dir_struct *GopherDirObjp;

#define GDgetEntry(a,b)  (((a)->Gophers[b]))
#define GDgetTop(a)  ((a)->Top)
#define GDsetTop(a,b)  ((a)->Top = (b))

/*** Real live functions declared in gopherstruct.c ***/

GopherDirObj *GDnew(int size);
void         GDdestroy(GopherDirObj *);
void         NEAR GDinit(GopherDirObj *);
void         GDaddGS(GopherDirObj *, GopherObj *);
void         GDsort(GopherDirObj);
void         GDtoNet(GopherDirObj *, int);
void	     GDtoLink(GopherDirObj *, FILE *);
int          GDfromNet(GopherDirObj *, int);
void	     GDfromLink(GopherDirObj *, FILE *, char *, int);
void         NEAR GDgrow(GopherDirObj *, int);
