/*
        shar.c - a very simple shell archiver
 
        author      : Sean Fuller (fuller@aedc-vax.af.mil)
                      Arnold Engineering and Development Center
 
        This software is provided "as is" without express or
        implied warranty.  In no event shall the author be liable
        for damages of any kind arising from or in connection
        with the use of this software.
 
*/

#include <stdio.h>

int main(int argc, char *argv[])
{
	int i;
	FILE *fp;
	char buf[256];
	fp = fopen("README", "r");
	if (fp == NULL)
	{
		fprintf(stderr, "Error: cannot open README\n");
		return 1;
	}
	while (!feof(fp))
	{
		if (fgets(buf, 256, fp) == NULL) break;
		printf("%s", buf);
	}
	fclose(fp);
	printf("#!/bin/sh\n");
	printf("# This is a shell archive.\n");
	for (i=1; i<argc; i++)
	{
		fp = fopen(argv[i], "r");
		if (fp == NULL)
		{
			fprintf(stderr, "Error: cannot open %s\n", argv[i]);
			return 1;
		}
		printf("echo unpacking %s...\n", argv[i]);
		printf("sed \"s/^X//\" >'%s' <<'END_OF_FILE'\n", argv[i]);
		while (!feof(fp))
		{
			if (fgets(buf, 256, fp) == NULL) break;
			printf("X%s", buf);
		}
		fclose(fp);
		printf("END_OF_FILE\n");
	}
	printf("echo done.\n");
	printf("exit 0\n");
	return 0;
}

