' Gophserv version 0.2
' Licensed by GNU GPL v3 or later version

#lang "fb"

' #**--Compile-time configuration settings--**# '
 const _version="0.2"
 const max_selector_len=255
 const file_block_size=1024
 const go5_initial_allocate=8
' #**---------------------------------------**# '

#include "file.bi"
#undef name
#if defined(__FB_WIN32__)
#define compile_target "WIN32"
#elseif defined(__FB_LINUX__)
#define compile_target "LINUX"
#elseif defined(__FB_DOS__)
#define compile_target "DOS"
#elseif defined(__FB_CYGWIN__)
#define compile_target "CYGWIN"
#elseif defined(__FB_FREEBSD__)
#define compile_target "FREEBSD"
#elseif defined(__FB_NETBSD__)
#define compile_target "NETBSD"
#elseif defined(__FB_OPENBSD__)
#define compile_target "OPENBSD"
#elseif defined(__FB_DARWIN__)
#define compile_target "DARWIN"
#elseif defined(__FB_XBOX__)
#define compile_target "XBOX"
#else
#define compile_target "UNKNOWN"
#endif
const crlf=chr(13)+chr(10)
const dotcrlf="."+crlf

dim shared as string selector,listcmd,relpath,typ,sel,fil

sub do_at_rule(name as string,value as string)
  select case name
    case "REL":relpath=value
    case else
      ?"3 Invalid @ command: "+name+crlf+dotcrlf;
  end select
end sub

sub do_internal(value as string)
  select case value
    case "ABOUTGOPHSERV"
      ?"Gophserv version "+_version+crlf;
      ?"Licensed by GNU GPL v3 or later version"+crlf;
      ?crlf;
      ?"Maximum selector length: "+str(max_selector_len)+crlf;
      ?"Binary file block size: "+str(file_block_size)+crlf;
      ?"Free memory: "+str(fre)+crlf;
      ?"Current date/time: "+date+" "+time+crlf;
      ?"Compiler version: "+__FB_SIGNATURE__+crlf;
      ?"Compile date/time: "+__DATE__+" "+__TIME__+crlf;
      ?"Operating system: "+compile_target+crlf;
      ?dotcrlf;
  end select
end sub

sub output_text_file(value as string)
  dim as string x
  if instr(value,":")=0 and left(value,1)<>"/" then value=relpath+value
  open value for input as #2
  do while not eof(2)
    line input #2,x
    ?x+crlf;
  loop
  ?dotcrlf;
  close #2
end sub

sub output_clientscript_file(value as string)
  dim as string x
  if instr(value,":")=0 and left(value,1)<>"/" then value=relpath+value
  open value for input as #2
  do while not eof(2)
    line input #2,x
    ?x;
  loop
  ?"!";
  close #2
end sub

sub output_binary_file(value as string)
  dim as integer x,fl,fb,lb
  dim as string*1 b
  dim as string*file_block_size bb
  if instr(value,":")=0 and left(value,1)<>"/" then value=relpath+value
  open value for binary access read as #2
  fb=1
  lb=lof(2)
  x=fb
  while lb-x>file_block_size
    x+=file_block_size
    get #2,x-file_block_size,bb
    ?bb;
  wend
  for x=x to lb
    get #2,x,b
    ?b;
  next x
  close #2
end sub

#include "gophserv_go5.bas"

dim as short i,j,k,l
dim as string ch

selector=""

do
  ch=input(1)
  if len(selector)>=max_selector_len then exit do
  if ch=chr(10) then exit do
  if ch<>chr(13) and ch<>chr(8) then selector+=ch
  if ch=chr(8) and len(selector)>0 then selector=left(selector,len(selector)-1)
loop

open command for input as #1
l=0
do while not eof(1)
  l+=1
  line input #1,listcmd
  if len(listcmd)>0 and left(listcmd,1)<>"#" then
    typ=left(listcmd,1)
    i=instr(1,listcmd,chr(9))
    sel=mid(listcmd,2,i-2)
    fil=mid(listcmd,i+1)
    select case typ
      case "@" 'at rule
        do_at_rule sel,fil
      case "I" 'internal
        if selector=sel then
          do_internal fil
          end
        end if
      case "0" 'text
        if selector=sel then
          output_text_file fil
          end
        end if
      case "9" 'binary
        if selector=sel then
          output_binary_file fil
          end
        end if
      case "E" 'executable script
        if instr(selector,sel)=1 then
          setenviron "SELECTOR="+selector
          shell fil
          end
        end if
      case "*" 'other list file
        if instr(selector,sel)=1 then
          close #1
          if instr(fil,":")=0 and left(fil,1)<>"/" then fil=relpath+fil
          open fil for input as #1
        end if
      case "7" 'go5 script
        if instr(selector,sel)=1 then run_go5_script fil
      case else
        ?"3 Error on line "+str(l)+crlf+dotcrlf;
        end
    end select
  end if
loop
?"3 File not found"+crlf+dotcrlf;
close #1

end
