' Gophserv (go5 script interpreter module)
' Licensed by GNU GPL v3 or later version

sub go5_error(linenum as short,value as string)
  ?crlf+"Go5 scripting error on line "+str(linenum)+crlf;
  ?value+crlf;
  end
end sub

function do_brainfuck(codes as string,byref mem as string,byref inpstr as string) as string
  dim as short i,j,memptr
  dim as string outstr=""
  dim as string x
  memptr=0
  for i=1 to len(codes)
    x=mid(codes,i,1)
    select case x
      case "+"
        mem[memptr]+=1
      case "-"
        mem[memptr]-=1
      case "."
        outstr+=chr(mem[memptr])
      case ","
        if len(inpstr) then
          mem[memptr]=inpstr[0]
          inpstr=mid(inpstr,2)
        else
          mem[memptr]=0
        end if
      case "<"
        memptr-=1
        if memptr<0 then
          memptr=0
          mem=chr(0)+mem
        end if
      case ">"
        memptr+=1
        if memptr>=len(mem) then mem=mem+chr(0)
      case "["
        if mem[memptr]=0 then
          j=1
          while j
            i+=1
            if mid(codes,i,1)="[" then j+=1
            if mid(codes,i,1)="]" then j-=1
          wend
        end if
      case "]"
        if mem[memptr] then
          j=-1
          while j
            i-=1
            if mid(codes,i,1)="[" then j+=1
            if mid(codes,i,1)="]" then j-=1
          wend
        end if
      case "(" 'this is start of memory (delete everything before it)
        mem=mid(mem,memptr+1)
        memptr=0
      case ")" 'delete this cell and everything after it, and move left
        mem=left(mem,memptr)
        memptr-=1
        if memptr<0 or len(mem)=0 then return outstr
    end select
  next i
  return outstr
end function

sub run_go5_script(value as string)
  redim as short go5mem(0 to go5_initial_allocate-1)
  dim as string par=mid(selector,len(sel)+1)
  dim as string cmd,cmdp,incmd,strmem(0 to 7)
  dim as short i,j,cmdn,linenum
  dim as short stackptr=0
  dim as string x
  dim as string nextlbl=""
  dim as longint li
  if instr(value,":")=0 and left(value,1)<>"/" then value=relpath+value
  open value for input as #2
  linenum=0
  do while not eof(2)
    if stackptr<0 then go5_error linenum,"Stack underflow"
    if stackptr>ubound(go5mem) then go5_error linenum,"Stack overflow"
    linenum+=1
    line input #2,incmd
    incmd=ltrim(incmd)
    if len(nextlbl) then
      if incmd=":"+nextlbl or nextlbl=str(linenum)+"#" then
        nextlbl=""
      else
        incmd=""
      end if
    end if
    if incmd="" or trim(incmd)="" or left(incmd,1)="#" or left(incmd,1)=":" then
      cmd="#"
    elseif left(incmd,1)>="0" and left(incmd,1)<="9" then
      cmd="push"
      cmdp=incmd
    elseif instr(incmd,":") then
      i=instr(incmd,":")
      cmd=left(incmd,i-1)
      cmdp=mid(incmd,i+1)
    elseif instr(incmd," ") then
      i=instr(incmd," ")
      cmd=left(incmd,i-1)
      cmdp=mid(incmd,i+1)
    elseif left(incmd,1)="," or right(incmd,1)="$" or left(incmd,1)="?" then
      cmd="push"
      cmdp=incmd
    else
      cmd=incmd
      cmdp=""
    end if
    if instr(incmd,":")=0 and cmd<>"#" then
      if left(cmdp,1)="?" then
        cmdp=str(cmdp[1])
      end if
      if left(cmdp,1)="," then
        stackptr-=1
        cmdn=go5mem(stackptr)
        cmdp=mid(cmdp,2)
      else
        cmdn=val(cmdp)
      end if
      while right(cmdp,1)=","
        cmdn=go5mem(cmdn)
        cmdp=left(cmdp,len(cmdp)-1)
      wend
      if right(cmdp,1)="$" and len(cmdp)=2 then
        cmdp=strmem(cmdn)
        cmdn=len(cmdp)
      elseif cmdp="rel$" then
        cmdp=relpath
        cmdn=len(cmdp)
      elseif cmdp="par$" then
        cmdp=par
        cmdn=len(cmdp)
      elseif cmdp="selector$" then
        cmdp=selector
        cmdn=len(cmdp)
      elseif cmdp="dir$" then
        cmdp=dir()
        cmdn=len(cmdp)
      end if
    end if
    select case cmd
      case "push"
        go5mem(stackptr)=cmdn
        stackptr+=1
      case "stop"
        end
      case "dotstop"
        ?crlf+dotcrlf;
        end
      case "tab"
        ?chr(9);
      case "out"
        ?cmdp;
      case "outln"
        ?cmdp+crlf;
      case "allocate"
        redim preserve go5mem(0 to cmdn-1)
      case "continue"
        exit do
      case "rel"
        relpath=cmdp
      case "selectlist"
        close #1
        if instr(cmdp,":")=0 and left(cmdp,1)<>"/" then cmdp=relpath+cmdp
        open cmdp for input as #1
        exit do
      case "shell"
        shell cmdp
      case "dir"
        stackptr-=1:i=go5mem(stackptr)
        if instr(cmdp,":")=0 and left(cmdp,1)<>"/" then cmdp=relpath+cmdp
        strmem(i)=dir(cmdp)
      case "drop"
        stackptr-=1
      case "store"
        if cmdn<0 or cmdn>ubound(go5mem) then go5_error linenum,"Index out of bounds"
        stackptr-=1
        go5mem(cmdn)=go5mem(stackptr)
      case "zero"
        go5mem(cmdn)=0
      case "increment"
        go5mem(cmdn)+=1
      case "decrement"
        go5mem(cmdn)-=1
      case "set"
        stackptr-=1:i=go5mem(stackptr)
        strmem(i)=cmdp
      case "append"
        stackptr-=1:i=go5mem(stackptr)
        strmem(i)=strmem(i)+cmdp
      case "add"
        go5mem(stackptr-1)+=cmdn
      case "subtract"
        go5mem(stackptr-1)-=cmdn
      case "multiply"
        go5mem(stackptr-1)*=cmdn
      case "text"
        close #2
        output_text_file cmdp
        end
      case "binary"
        close #2
        output_binary_file cmdp
        end
      case "stack"
        stackptr=cmdn
      case "goto"
        nextlbl=cmdp
        close #2
        open value for input as #2
        linenum=0
      case "ifz"
        stackptr-=1:i=go5mem(stackptr)
        if i=0 then
          nextlbl=cmdp
          close #2
          open value for input as #2
          linenum=0
        end if
      case "ifnz"
        stackptr-=1:i=go5mem(stackptr)
        if i then
          nextlbl=cmdp
          close #2
          open value for input as #2
          linenum=0
        end if
      case "ifneg"
        stackptr-=1:i=go5mem(stackptr)
        if i<0 then
          nextlbl=cmdp
          close #2
          open value for input as #2
          linenum=0
        end if
      case "ifpos"
        stackptr-=1:i=go5mem(stackptr)
        if i>0 then
          nextlbl=cmdp
          close #2
          open value for input as #2
          linenum=0
        end if
      case "lalign"
        stackptr-=1:i=go5mem(stackptr)
        x=strmem(cmdn)
        strmem(cmdn)=space(i)
        lset strmem(cmdn),x
      case "ralign"
        stackptr-=1:i=go5mem(stackptr)
        x=strmem(cmdn)
        if i>=len(x) then
          strmem(cmdn)=space(i)
          rset strmem(cmdn),x
        else
          strmem(cmdn)=right(x,i)
        end if
      case "selector"
        selector=cmdp
      case "decimal"
        stackptr-=1:i=go5mem(stackptr)
        strmem(cmdn)=trim(str(i))
      case "hex"
        stackptr-=1:i=go5mem(stackptr)
        strmem(cmdn)=hex(i)
      case "filesize"
        stackptr-=1:i=go5mem(stackptr)
        if instr(cmdp,":")=0 and left(cmdp,1)<>"/" then cmdp=relpath+cmdp
        li=filelen(cmdp)
        if li<4500 then
          strmem(i)=trim(str(li))
        elseif li<1048576 then
          strmem(i)=trim(str(li\1024))+"k"
        else
          strmem(i)=trim(str(li\1048576))+"M"
        end if
      case "split"
        stackptr-=1:j=go5mem(stackptr)
        stackptr-=1:i=go5mem(stackptr)
        if instr(strmem(i),chr(cmdn)) then
          strmem(j)=mid(strmem(i),instr(strmem(i),chr(cmdn))+1)
          strmem(i)=left(strmem(i),instr(strmem(i),chr(cmdn))-1)
        else
          strmem(j)=strmem(i)
          strmem(i)=""
        end if
      case "value"
        go5mem(stackptr)=val(cmdp)
        stackptr+=1
      case "lcase"
        strmem(cmdn)=lcase(strmem(cmdn))
      case "ucase"
        strmem(cmdn)=ucase(strmem(cmdn))
      case "endswith"
        stackptr-=1:i=go5mem(stackptr)
        i=(right(strmem(i),len(cmdp))=cmdp)
        go5mem(stackptr)=i:stackptr+=1
      case "beginswith"
        stackptr-=1:i=go5mem(stackptr)
        i=(left(strmem(i),len(cmdp))=cmdp)
        go5mem(stackptr)=i:stackptr+=1
      case "instr"
        stackptr-=1:i=go5mem(stackptr)
        i=instr(strmem(i),cmdp)
        go5mem(stackptr)=i:stackptr+=1
      case "strcmp"
        stackptr-=1:i=go5mem(stackptr)
        if strmem(i)=cmdp then j=0
        if strmem(i)<cmdp then j=-1
        if strmem(i)>cmdp then j=1
        go5mem(stackptr)=j:stackptr+=1
      case "psplit"
        stackptr-=1:j=go5mem(stackptr)
        if instr(par,chr(cmdn)) then
          strmem(j)=mid(par,instr(par,chr(cmdn))+1)
          par=left(par,instr(par,chr(cmdn))-1)
        else
          strmem(j)=par
          par=""
        end if
      case "randomize"
        randomize timer
      case "random"
        go5mem(stackptr)=int(rnd*cmdn)
        stackptr+=1
      case "gosub"
        go5mem(stackptr)=linenum+1
        stackptr+=1
        nextlbl=cmdp
        close #2
        open value for input as #2
        linenum=0
      case "return"
        stackptr-=1:i=go5mem(stackptr)
        nextlbl=str(i)+"#"
        close #2
        open value for input as #2
        linenum=0
      case "brainfuck"
        stackptr-=1:i=go5mem(stackptr)
        if left(cmdp,1)="?" then
          strmem(i)=do_brainfuck(cmdp,chr(0),strmem(i))
        else
          ?do_brainfuck(cmdp,strmem(i),par);
        end if
      case "emit"
        ?chr(cmdn);
      case "chop"
        go5mem(stackptr)=strmem(cmdn)[0]
        strmem(cmdn)=mid(strmem(cmdn),2)
        stackptr+=1
      case "toasc"
        stackptr-=1:j=go5mem(stackptr)
        if i+len(strmem(j))>ubound(go5mem) then go5_error linenum,"String won't fit in memory"
        for i=0 to len(strmem(j))-1
          go5mem(cmdn+i)=strmem(j)[i]
        next i
      case "ascto"
        stackptr-=1:j=go5mem(stackptr)
        if i+len(strmem(j))>ubound(go5mem) then go5_error linenum,"String won't fit in memory"
        for i=0 to len(strmem(j))-1
          strmem(j)[i]=go5mem(cmdn+i)
        next i
      case "modulo"
        go5mem(stackptr-1)=go5mem(stackptr-1) mod cmdn
      case "dup"
        go5mem(stackptr)=go5mem(stackptr-1)
        stackptr+=1
      case "xbinary"
        nextlbl=str(linenum+1)+"#"
        close #2
        output_binary_file cmdp
        open value for input as #2
      case "clientscript"
        nextlbl=str(linenum+1)+"#"
        close #2
        output_clientscript_file cmdp
        open value for input as #2
      case "#" 'comment, does nothing
    end select
  loop
  close #2
end sub
