' Creates image indexes for gophserv
' Licensed by GNU GPL version 3 or later version

#lang "fb"

dim shared as string dir_prefix,server_name,server_port

sub enter_filename(filename as string,typecode as string)
  ?#2,"9"+dir_prefix+filename+chr(9)+filename
  ?#3,typecode+filename+chr(9)+dir_prefix+filename+chr(9)+server_name+chr(9)+server_port
end sub

sub process_dir(dirname as string)
  dim as string a,b
  ?#2,"@REL"+chr(9)+dirname
  a=dir(dirname+"*")
  while len(a)
    if right(lcase(a),4)=".jpg" then enter_filename a,"I"
    if right(lcase(a),5)=".jpeg" then enter_filename a,"I"
    if right(lcase(a),4)=".png" then enter_filename a,"p"
    if right(lcase(a),4)=".gif" then enter_filename a,"g"
    if right(lcase(a),4)=".xbm" then enter_filename a,"I"
    if right(lcase(a),5)=".tiff" then enter_filename a,"I"
    if right(lcase(a),4)=".txt" then enter_filename a,"0"
    a=dir()
  wend
end sub

sub process_line(linestr as string)
  select case left(linestr,1)
    case "*"
      close #2
      open mid(linestr,2) for output as #2
    case "1"
      close #3
      open mid(linestr,2) for output as #3
    case ":"
      ?#3,mid(linestr,2)
    case "i"
      ?#3,linestr
    case "_"
      dir_prefix=mid(linestr,2)
    case "/"
      process_dir mid(linestr,2)
    case "n"
      server_name=mid(linestr,2)
    case "p"
      server_port=mid(linestr,2)
    case "","#" 'comment, does nothing
    case else
      ?"Invalid parameter"
      end 1
  end select
end sub

dim as string a
if command="" then
  ?"IMGINDEX"
  ?
  ?"Licensed by GNU GPL version 3 or later version"
  ?"See file called COPYING for license details"
  ?
  ?"Needs command line parameter"
  end 1
end if
open command for input as #1
do while not eof(1)
  line input #1,a
  process_line a
loop
?"OK"
end 0
